define("jira/issues/modules/pager/view", ["require"], function(require) {
    "use strict";

    var jQuery = require("jquery");
    var MarionetteItemView = require("jira/components/libs/marionette-1.4.1/itemview");
    var PagerTemplates = require("jira/issues/modules/pager/templates");
    var AJSHelper = require('jira/issues/libs/ajshelper');

    return MarionetteItemView.extend({
        template: function(data) {
            return PagerTemplates.pager(data || {});
        },

        events: {
            "simpleClick #return-to-search": "_onReturnToSearchClick"
        },

        triggers: {
            "simpleClick #next-issue": "nextItem",
            "simpleClick #previous-issue": "previousItem"
        },

        ui: {
            nextIssue: "#next-issue",
            previousIssue: "#previous-issue",
            returnToSearch: "#return-to-search"
        },

        modelEvents: {
            "change": "render"
        },

        onRender: function() {
            var shortcuts = AJSHelper.activeShortcuts();
            if (shortcuts) {
                if (shortcuts.j) { shortcuts.j._addShortcutTitle(this.$el.find(this.ui.nextIssue));}
                if (shortcuts.k) { shortcuts.k._addShortcutTitle(this.$el.find(this.ui.previousIssue));}
                if (shortcuts.u) { shortcuts.u._addShortcutTitle(this.$el.find(this.ui.returnToSearch));}
            }
        },

        _onReturnToSearchClick: function (e) {
            e.preventDefault();
            this.trigger("goBack");

            //IE8 and IE9 do not return focus back to the body after pressing the Return to Search link
            //Thus any subsequent shortcut operations will not work because the focus is wrong
            //This is to return focus back to body
            jQuery("body").focus();
        }
    });
});
