AJS.test.require(["com.atlassian.jira.jira-issue-nav-plugin:pager-test"], function() {
    "use strict";

    var PagerView = require("jira/issues/modules/pager/view");
    var MockUtils = require("jira/components/test-utils/mockutils");
    var MarionetteMocker = require("jira/components/test-utils/marionettemocker");

    module("jira/issues/modules/pager/controller", {
        setup: function() {
            this.sandbox = sinon.sandbox.create();

            this.PagerView = MarionetteMocker.createEventedMock(this.sandbox, PagerView);

            this.PagerControllerConstructor = MockUtils.requireWithMocks("jira/issues/modules/pager/controller", {
                "jira/issues/modules/pager/view": this.PagerView.constructor
            });
        },
        teardown: function() {
            this.sandbox.restore();
        }
    });

    test("When the controller is initialised, it should set up the model", function () {
        var controller = new this.PagerControllerConstructor();
        var options = {
            model: "foobar"
        };
        controller.initialize(options);

        equal(options.model, controller.model);
    });

    test("When the view is requested but doesn't exist, it should be created", function() {
        var container = "foo";
        var controller = new this.PagerControllerConstructor();

        sinon.stub(controller, "listenTo");
        sinon.stub(controller, "listenAndRethrow");
        controller.model = "bar";
        var pagerView = controller.getView(container);

        sinon.assert.calledWith(this.PagerView.constructor, sinon.match({
            model: controller.model,
            el: container
        }));
        equal(controller.pagerView, pagerView);
    });

    test("When the view is requested with a container, it should use that container for the view", function() {
        var container = "foo";

        var controller = new this.PagerControllerConstructor();
        controller.pagerView = this.PagerView;
        var pagerView = controller.getView(container);

        sinon.assert.calledWith(this.PagerView.setElement, container);
        deepEqual(controller.pagerView, pagerView);
    });

    test("When a view is displayed, it should render the view", function() {
        var view = {render: function() {}};
        var container = {pager: "foo", isError: false};
        this.stub(view, "render");

        var controller = new this.PagerControllerConstructor();
        controller.model = sinon.stub({set: function(){}});
        this.stub(controller, "getView").withArgs(container.pager).returns(view);

        controller.show(container);

        sinon.assert.calledOnce(view.render);
    });

    test("When an error view is displayed, it should inform the model", function() {
        var view = {render: function() {}};
        var container = {pager: "foo", isError: true};
        this.stub(view, "render");

        var controller = new this.PagerControllerConstructor();
        controller.model = {set: function(){}};
        this.stub(controller.model, "set");
        this.stub(controller, "getView").withArgs(container.pager).returns(view);

        controller.show(container);

        sinon.assert.calledWith(controller.model.set, 'isError', container.isError);
    });

    test("When a view is destroyed, it should delete it from the controller", function() {
        var controller = new this.PagerControllerConstructor();
        controller.pagerView = {};

        controller.destroyView();

        equal(controller.hasOwnProperty('pagerView'), false, "view not deleted from controller");
    });
});
