define("jira/issues/modules/pager/appmodule", ["require"], function(require) {
    "use strict";

    var Pager = require("jira/issues/modules/pager");
    var IssuesAPI = require('jira/issues/api');

    return function(PagerModule, app) {
        var pager = new Pager({
            nextItem: function() {
                //TODO Refactor to app commands
                IssuesAPI.nextIssue();
            },
            previousItem: function() {
                //TODO Refactor to app commands
                IssuesAPI.prevIssue();
            },
            goBack: function() {
                app.execute("returnToSearch");
            }
        });

        app.addInitializer(function() {
            pager.initialize();
            app.commands.setHandlers({
                "pager:update": pager.update,
                "pager:render": pager.show,
                "pager:close": pager.close
            });
        });
    };

});
