define("jira/issues/modules/pager", ["require"], function(require) {
    "use strict";

    var PagerModel = require("jira/issues/modules/pager/model");
    var PagerController = require("jira/issues/modules/pager/controller");

    return function(callbacks) {
        var pagerModel;
        var pagerController;

        this.initialize = function() {
            pagerModel = new PagerModel();
        };

        this.update = function(data) {
            if (data) {
                pagerModel.update(data);
            } else if (pagerModel.get('isError') !== true) {
                pagerModel.clear();
            }
        };

        this.show = function(container, element) {
            if (!pagerController) {
                pagerController = new PagerController({
                    model: pagerModel
                });
                pagerController.on("goBack", callbacks.goBack);
                pagerController.on("nextItem", callbacks.nextItem);
                pagerController.on("previousItem", callbacks.previousItem);
            }
            pagerController.show(container, element);
        };

        this.close = function() {
            if (pagerController) {
                pagerController.close();
            }
            pagerController = null;
            pagerModel.clear();
        };
    };

});
