define('jira/issues/modules/navigation/state', ['require'], function (require) {
    "use strict";

    var URLSerializer = require('jira/issues/utils/url-serializer');
    var _ = require('underscore');

    /**
     * An object representing  application state.
     * @property {number} filter - ID of the filter
     * @property {string} selectedIssueKey - key of the selected issue
     * @property {string} jql - JQL of the search
     * @property {string} filterJql - JQL of the filter
     * @property {number} startIndex - 0-based index of the first issue visible in search results
     * @property {string} viewIssueQuery - a query parameters for the view issue page
     * @property {number} searchId - unique search id
     * @constructor
     *
     * @param {Object} state - an object containing initial state parameters
     */
    var State = function State(state) {
        this.filter = null;
        this.jql = null;
        if (state) {
            _.extend(this, state.toJSON());
        }
    };

    _.extend(State.prototype,
    /** @lends State.prototype */
    {
        /**
         * Construct an URL representation
         *
         * @returns {string} URL representation of state
         */
        toUrl: function toUrl() {
            return URLSerializer.getURLFromState(this);
        },
        /**
         * Does this state represent standalone issue (View Issue page)
         *
         * @returns {boolean}
         */
        isStandaloneIssue: function isStandaloneIssue() {
            return Boolean(this.selectedIssueKey) && !_.isString(this.jql) && !this.filter;
        },
        /**
         * Convert URL to state object
         *
         * @param {string} url - URL from which the state will be derived
         * @returns {State} state object
         */
        getStateFromUrl: function getStateFromUrl(url) {
            return URLSerializer.getStateFromURL(url);
        }
    });

    return State;
});
