define('jira/issues/components/table/views/issue-table', ['require'], function (require) {
    "use strict";

    var flag = require("jira/flag");
    var BaseView = require('jira/issues/baseview');
    var _ = require('underscore');
    var jQuery = require('jquery');
    var Resize = require('jira/issues/utils/resize');

    /**
     * The issue table rendered in <tt>JIRA.Issues.FullScreenLayout</tt>.
     */
    return BaseView.extend({
        _closeSystemModeMessage: function() {
            if (this.currentMessage) {
                this.currentMessage.close();
                this.currentMessage = null;
            }
        },

        _showSystemModeMessage: function() {
            if (this.currentMessage) return; // Message already there, not need to display a new one
            var $msg = flag.showMsg('', AJS.I18n.getText("issues.components.column.config.system.warning.post"), {
                type: 'warning',
                close: 'never'
            });

            jQuery($msg).find(".exit").click(_.bind(function (e) {
                e.preventDefault();
                this.columnConfig.setCurrentColumnConfig("user");
                this._closeSystemModeMessage();
            }, this));

            this.currentMessage = $msg;
        },

        syncSystemModeMessage: function() {
            var isSystemMode = this.columnConfig.isSystemMode();
            if (isSystemMode) {
                this._showSystemModeMessage();
            } else {
                this._closeSystemModeMessage();
            }
        },

        /**
         * @param {object} options
         * @param {JIRA.Issues.SearchModule} options.search The application's <tt>JIRA.Issues.SearchModule</tt> instance.
         * @param {JIRA.Issues.SearchResults} options.searchResults The application's <tt>JIRA.Issues.SearchResults</tt> instance.
         */
        initialize: function(options) {
            this.columnConfig = options.columnConfig;
            this.columnConfig.on("change:columnConfig", this.syncSystemModeMessage, this);
            Resize.onVerticalResize(_.bind(this.adjustColumnConfigHeight, this));
        },

        /**
         * Prepare to be removed, unbinding all event handlers, etc.
         */
        deactivate: function() {
            Resize.offVerticalResize(this.adjustColumnConfigHeight);
        },

        /**
         * Render the issue table after a search completes.
         * <p/>
         * Called when an operation in <tt>searchPromise</tt> completes.
         *
         * @param {object} el The search payload.
         * @private
         */
        _onSearchDone: function(el) {
            this.columnConfig.setElement(el.find(".column-picker-trigger-container")).render();
        },

        adjustColumnConfigHeight: function() {
            this.columnConfig.adjustHeight();
        }
    });
});
