AJS.test.require(["com.atlassian.jira.jira-issue-nav-plugin:issuetable-component-test"], function () {
    "use strict";

    var jQuery = require("jquery");
    var wrmContextPath = require("wrm/context-path");
    var _ = require("underscore");
    var Pagination = require("jira/issues/components/issue-table/views/pagination");

    module("jira/issues/components/issue-table/views/pagination");

    test("It takes into account the current filter and jql when generating the pagination links", function () {
        var runTest = _.bind(function (filterId, jql, expected) {
            var paginationView = new Pagination({
                startIndex: 50,
                pageSize: 10,
                displayableTotal: 100,
                currentSearch: {
                    jql: jql,
                    filterId: filterId
                }
            });
            paginationView.render();

            var previousLink = paginationView.$("a").eq(0).attr('href');
            equal(previousLink, expected);
        }, this);

        runTest(null, "lala", wrmContextPath() + "/issues/?jql=lala&startIndex=40");
        runTest("booboo", null, wrmContextPath() + "/issues/?filter=booboo&startIndex=40");
        runTest("booboo", "lala", wrmContextPath() + "/issues/?filter=booboo&jql=lala&startIndex=40");
    });

    test("It renders the pagination links", function () {
        var paginationView = new Pagination({
            startIndex: 0,
            pageSize: 10,
            total: 95,
            currentSearch: {
                jql: ""
            }
        });
        paginationView.render();

        equal(paginationView.$el.find('strong').text(), 1, "Current page is rendered");
        equal(paginationView.$el.find('a.icon').length, 1, "Only 1 of the prev/next page icons is rendered");
        equal(paginationView.$el.find('a.icon').attr('href'), wrmContextPath() + '/issues/?jql=&startIndex=10', "Icon for next page has correct url");
        equal(paginationView.$el.find('a:not(.icon)').length, 4, "It render 4 numbers");
        paginationView.$el.find('a:not(.icon)').each(function (i) {
            equal(jQuery(this).text(), i + 2, "Page number is correctly rendered");
            equal(jQuery(this).attr('href'), wrmContextPath() + '/issues/?jql=&startIndex=' + (i + 1) * 10, "Link href is correct");
        });
    });

    test("It renders the correct values when there is only one page", function () {
        var paginationView = new Pagination({
            startIndex: 0,
            pageSize: 10,
            total: 10,
            currentSearch: {
                jql: ""
            }
        });
        paginationView.render();

        ok(paginationView.$el.is('.pagination'), "Has pagination element inside");
        equal(paginationView.$el.text(), '', "Nothing rendered");
    });
});
