define('jira/issues/components/issue-table/views/issue-table-layout', ['require'], function (require) {
    "use strict";

    var Layout = require('jira/components/libs/marionette-1.4.1/layout');
    var ReplaceRegion = require('jira/components/libs/marionette-1.4.1/replaceregion');
    var Templates = require('jira/issues/templates/issue-nav-table');

    return Layout.extend({
        template: Templates.structure,

        regions: {
            pagination: {
                selector: ".pagination",
                regionType: ReplaceRegion
            },
            table: ".issue-table-container",
            resultsCountTop: {
                selector: ".results-count-top",
                regionType: ReplaceRegion
            },
            refreshResultsTop: {
                selector: ".refresh-table-top",
                regionType: ReplaceRegion
            },
            resultsCountBottom: {
                selector: ".results-count-bottom",
                regionType: ReplaceRegion
            },
            refreshResultsBottom: {
                selector: ".refresh-table-bottom",
                regionType: ReplaceRegion
            },
            endOfStableMessage: {
                selector: ".end-of-stable-message",
                regionType: ReplaceRegion
            }
        },

        onRender: function() {
            this.hidePending();
        },

        showPending: function() {
            this.$el.addClass('pending');
        },

        hidePending: function() {
            this.$el.removeClass("pending");
        }
    });
});
