AJS.test.require(["com.atlassian.jira.jira-issue-nav-plugin:issuetable-component-test"],function(){var c=require("jquery");var a=require("jira/issues/test/utils");var b;module("jira/issues/components/issue-table/controllers/issue-table",{setup:function(){this.sandbox=sinon.sandbox.create();var d=AJS.test.mockableModuleContext();this.mocks={IssueTableLayout:a.mockModule(this.sandbox,d,"jira/issues/components/issue-table/views/issue-table-layout"),EmptyResults:a.mockModule(this.sandbox,d,"jira/issues/components/issue-table/views/empty-results"),ResultsCount:a.mockModule(this.sandbox,d,"jira/issues/components/issue-table/views/results-count"),Pagination:a.mockModule(this.sandbox,d,"jira/issues/components/issue-table/views/pagination"),RefreshResults:a.mockModule(this.sandbox,d,"jira/issues/components/issue-table/views/refresh-results"),EndOfStableMessage:a.mockModule(this.sandbox,d,"jira/issues/components/issue-table/views/end-of-stable-message"),IssueTableView:a.mockModule(this.sandbox,d,"jira/issues/components/issue-table/views/issue-table")};b=d.require("jira/issues/components/issue-table/controllers/issue-table");this.controller=new b({el:c("#qunit-fixture")})},teardown:function(){this.sandbox.restore()},resultsWithIssues:{hasIssues:true,currentSearch:{jql:"project = BULK",filterId:null},sortOptions:{},totalIssues:42,totalDisplayableIssues:42,startIndex:0,pageSize:10,pageNumber:0,totalPages:5,table:["<table>","<tbody>","<tr class='focused issuerow' rel='10000'><td>JRA-1</td></tr>","<tr class='issuerow' rel='10010'><td>JRA-2</td></tr>","</tbody>","</table>"].join("")},resultsWithoutIssues:{hasIssues:false},assertRethrowEventFromView:function(e,d){var f=this.spy();this.controller.on(e,f);this.controller.show(this.resultsWithIssues);d.thisValues[0].trigger(e);sinon.assert.calledOnce(f)}});test("It renders the table if search contain some results",function(){this.controller.show(this.resultsWithIssues);sinon.assert.calledOnce(this.mocks.IssueTableLayout);ok(this.mocks.IssueTableLayout.calledWithNew());sinon.assert.calledOnce(this.mocks.IssueTableLayout.prototype.render)});test("It renders the empty results message if the search contains no results",function(){this.controller.show(this.resultsWithoutIssues);sinon.assert.calledOnce(this.mocks.EmptyResults);ok(this.mocks.EmptyResults.calledWithNew());sinon.assert.calledOnce(this.mocks.EmptyResults.prototype.render)});test("It marks the rendered view as pending",function(){this.controller.show(this.resultsWithoutIssues);this.controller.showPending();sinon.assert.calledOnce(this.mocks.EmptyResults.prototype.showPending);this.controller.show(this.resultsWithIssues);this.controller.showPending();sinon.assert.calledOnce(this.mocks.IssueTableLayout.prototype.showPending)});test("It renders the error message",function(){this.controller.showErrorMessage();sinon.assert.calledOnce(this.mocks.EmptyResults);ok(this.mocks.EmptyResults.calledWithNew());sinon.assert.calledOnce(this.mocks.EmptyResults.prototype.render)});test("When rendering the table, it closes the previously rendered view",function(){this.controller.show(this.resultsWithIssues);this.controller.show(this.resultsWithIssues);sinon.assert.calledOnce(this.mocks.IssueTableLayout.prototype.close)});test("When rendering the table, it renders the main table",function(){this.controller.show(this.resultsWithIssues);sinon.assert.calledOnce(this.mocks.IssueTableView);sinon.assert.calledWithExactly(this.mocks.IssueTableView,{resultsTable:this.resultsWithIssues.table,sortOptions:this.resultsWithIssues.sortOptions});ok(this.mocks.IssueTableView.calledWithNew());sinon.assert.calledOnce(this.mocks.IssueTableView.prototype.render)});test("When rendering the table, it renders two results counts",function(){this.controller.show(this.resultsWithIssues);sinon.assert.calledTwice(this.mocks.ResultsCount);sinon.assert.calledWithExactly(this.mocks.ResultsCount,{total:this.resultsWithIssues.totalIssues,startIndex:this.resultsWithIssues.startIndex,pageSize:this.resultsWithIssues.pageSize});ok(this.mocks.ResultsCount.calledWithNew());sinon.assert.calledTwice(this.mocks.ResultsCount.prototype.render)});test("When rendering the table, it renders the pagination",function(){this.controller.show(this.resultsWithIssues);sinon.assert.calledOnce(this.mocks.Pagination);sinon.assert.calledWithExactly(this.mocks.Pagination,{total:this.resultsWithIssues.totalIssues,startIndex:this.resultsWithIssues.startIndex,pageSize:this.resultsWithIssues.pageSize,currentSearch:this.resultsWithIssues.currentSearch});ok(this.mocks.Pagination.calledWithNew());sinon.assert.calledOnce(this.mocks.Pagination.prototype.render)});test("When rendering the table, it renders two refresh results buttons",function(){this.controller.show(this.resultsWithIssues);sinon.assert.calledTwice(this.mocks.RefreshResults);ok(this.mocks.RefreshResults.calledWithNew());sinon.assert.calledTwice(this.mocks.RefreshResults.prototype.render)});test("When rendering the table, it renders the end of stable message",function(){this.controller.show(this.resultsWithIssues);sinon.assert.calledOnce(this.mocks.EndOfStableMessage);sinon.assert.calledWithExactly(this.mocks.EndOfStableMessage,{total:this.resultsWithIssues.totalIssues,displayableTotal:this.resultsWithIssues.totalDisplayableIssues,pageNumber:this.resultsWithIssues.pageNumber,numberOfPages:this.resultsWithIssues.numberOfPages});ok(this.mocks.EndOfStableMessage.calledWithNew());sinon.assert.calledOnce(this.mocks.EndOfStableMessage.prototype.render)});test("When rendering the table, it stores the view's markup in $el",function(){this.controller.show(this.resultsWithIssues);equal(this.controller.$el.find("table").length,1)});test("When rendering the table, it triggers the 'renderTable' event with $el as payload",function(){var d=this.spy();this.controller.on("renderTable",d);this.controller.show(this.resultsWithIssues);sinon.assert.calledOnce(d);sinon.assert.calledWithExactly(d,this.controller.$el)});test("When rendering the empty messages, it closes the previously rendered view",function(){this.controller.show(this.resultsWithIssues);this.controller.show(this.resultsWithoutIssues);sinon.assert.calledOnce(this.mocks.IssueTableLayout.prototype.close)});test("When rendering the empty message, it stores the view's markup in $el",function(){this.controller.show(this.resultsWithoutIssues);equal(this.controller.$el.find(".empty-results").length,1)});test("It highlights an issue in the table",function(){this.controller.show(this.resultsWithIssues);this.controller.highlightIssue(10000);sinon.assert.calledOnce(this.mocks.IssueTableView.prototype.highlightIssue);sinon.assert.calledWithExactly(this.mocks.IssueTableView.prototype.highlightIssue,10000,undefined)});test("It marks an issue as inaccessible in the table",function(){this.controller.show(this.resultsWithIssues);this.controller.markIssueAsInaccessible(10000);sinon.assert.calledOnce(this.mocks.IssueTableView.prototype.markIssueAsInaccessible);sinon.assert.calledWithExactly(this.mocks.IssueTableView.prototype.markIssueAsInaccessible,10000)});test("It updates an issue in the table",function(){this.controller.show(this.resultsWithIssues);this.controller.updateIssue(10000,"<table></table>");sinon.assert.calledOnce(this.mocks.IssueTableView.prototype.updateIssue);sinon.assert.calledWithExactly(this.mocks.IssueTableView.prototype.updateIssue,10000,"<table></table>")});test("It rethrows the 'columnsChanged' event from the table view",function(){this.assertRethrowEventFromView("columnsChanged",this.mocks.IssueTableView)});test("It rethrows the 'highlightIssue' event from the table view",function(){this.assertRethrowEventFromView("highlightIssue",this.mocks.IssueTableView)});test("It rethrows the 'issueRowUpdated' event from the table view",function(){this.assertRethrowEventFromView("issueRowUpdated",this.mocks.IssueTableView)});test("It rethrows the 'sort' event from the table view",function(){this.assertRethrowEventFromView("sort",this.mocks.IssueTableView)});test("It rethrows the 'goToPage' event from the pagination view",function(){this.assertRethrowEventFromView("goToPage",this.mocks.Pagination)});test("It rethrows the 'refresh' event from the refresh results view",function(){this.assertRethrowEventFromView("refresh",this.mocks.RefreshResults)})});