AJS.test.require(["com.atlassian.jira.jira-issue-nav-plugin:issuetable-component-test"], function () {
    "use strict";

    var jQuery = require("jquery");
    var Events = require("jira/util/events");
    var Reasons = require("jira/util/events/reasons");
    var Types = require("jira/util/events/types");
    var Application = require("jira/issues/application");
    var IssueTable = require("jira/issues/components/issue-table");
    var MockSearchModule = require("jira/issues/test/mock-search-module");
    var TestUtils = require("jira/issues/test/utils");
    var SearchService = require("jira/issues/components/search");

    module("jira/issues/components/issue-table", {
        setup: function () {
            sinon.stub(Application, "request").withArgs("issueEditor:canDismissComment").returns(true);
            sinon.stub(Application, "execute");

            var searchModule = new MockSearchModule();
            var columnConfig = TestUtils.mockColumnConfig();
            var searchService = new SearchService({
                searchModule: searchModule,
                searchResults: searchModule.getResults(),
                columnConfig: columnConfig
            });

            this.issueTable = new IssueTable({
                columnConfig: columnConfig,
                searchService: searchService,
                el: jQuery("#qunit-fixture")
            });
        },

        teardown: function () {
            Application.request.restore();
            Application.execute.restore();
        }
    });

    test("It should trigger a JIRA.Events.NEW_CONTENT_ADDED when the table is rendered", function () {
        var triggerSpy = this.sandbox.spy(Events, "trigger");

        var table = jQuery("<div></div>");
        this.issueTable.issueTableController.trigger("renderTable", table);

        equal(triggerSpy.callCount, 1, "One event is triggered");
        equal(triggerSpy.firstCall.args[0], Types.NEW_CONTENT_ADDED, "First event is JIRA.Events.NEW_CONTENT_ADDED");
        equal(triggerSpy.firstCall.args[1][1], Reasons.issueTableRefreshed, "First event reason is JIRA.CONTENT_ADDED_REASON.issueTableRefreshed");

        triggerSpy.restore();
    });

    test("It should trigger a JIRA.Events.NEW_CONTENT_ADDED when the empty message is rendered", function () {
        var triggerSpy = this.sandbox.spy(Events, "trigger");

        var table = jQuery("<div></div>");
        this.issueTable.issueTableController.trigger("renderEmpty", table);

        equal(triggerSpy.callCount, 1, "One event is triggered");
        equal(triggerSpy.firstCall.args[0], Types.NEW_CONTENT_ADDED, "First event is JIRA.Events.NEW_CONTENT_ADDED");
        equal(triggerSpy.firstCall.args[1][1], Reasons.issueTableRefreshed, "First event reason is JIRA.CONTENT_ADDED_REASON.issueTableRefreshed");

        triggerSpy.restore();
    });

    test("It should trigger a JIRA.Events.NEW_CONTENT_ADDED when an issue is updated", function () {
        var triggerSpy = this.sandbox.spy(Events, "trigger");

        var table = jQuery("<div></div>");
        this.issueTable.issueTableController.trigger("issueRowUpdated", table);

        equal(triggerSpy.callCount, 1, "One event is triggered");
        equal(triggerSpy.firstCall.args[0], Types.NEW_CONTENT_ADDED, "Event is JIRA.Events.NEW_CONTENT_ADDED");
        equal(typeof triggerSpy.firstCall.args[1][1], "string", "Ensure event has a reason argument");
        equal(triggerSpy.firstCall.args[1][1], Reasons.issueTableRowRefreshed, "Event reason is JIRA.CONTENT_ADDED_REASON.issueTableRowRefreshed");

        triggerSpy.restore();
    });
});
