AJS.test.require(["com.atlassian.jira.jira-issue-nav-plugin:filters-component-test"], function () {
    "use strict";

    var Filter = require("jira/issues/components/filters/entities/filter");
    var Filters = require("jira/issues/components/filters/entities/filters");
    var ListWithActions = require("jira/issues/components/filters/views/list/list-with-actions");

    module("jira/issues/components/filters/views/list/list-with-actions", {
        createView: function (options) {
            return new ListWithActions({
                collection: new Filters(options.models),
                className: options.className
            });
        }
    });

    test("When rendering using actions, it renders the items with an actions trigger", function () {
        var models = [
            new Filter({name: "My filter"})
        ];
        var view = this.createView({models: models});

        view.render();

        equal(view.$el.find("a.filter-actions").length, 1, "Contains the actions trigger");
    });
});
