AJS.test.require(["com.atlassian.jira.jira-issue-nav-plugin:filters-component-test"], function () {
    "use strict";

    var DialogUtil = require('jira/dialog/dialog-util');
    var _ = require("underscore");
    var Filter = require("jira/issues/components/filters/entities/filter");
    var DeleteDialog = require("jira/issues/components/filters/views/dialogs/delete");
    var TestUtils = require("jira/issues/components/testutils");

    module('jira/issues/components/filters/views/dialogs/delete', {
        setup: function () {
            this.server = sinon.fakeServer.create();
            this.sandbox = sinon.sandbox.create();
            this.sandbox.stub(DialogUtil, "getDefaultAjaxOptions").returns({url: "/jira/secure/DeleteFilter!default.jspa?filterId=1234"});
        },

        teardown: function () {
            this.server.restore();
            this.sandbox.restore();
        },

        renderDialog: function (dialog) {
            dialog.render();
            TestUtils.moveDialogToQunitFixture(dialog);

            _.last(this.server.requests).respond(200);
        }
    });

    test("It uses JIRA action to render the delete dialog", function () {
        var dialog = new DeleteDialog({
            model: new Filter({
                subscriptions: {
                    items: []
                },
                id: "1234"
            })
        });
        this.renderDialog(dialog);

        ok(_.last(this.server.requests).url.match("/secure/DeleteFilter!default\\.jspa\\?filterId=1234"), "Request to the JIRA dialog action");
        equal(_.last(this.server.requests).method, "GET", "Request uses the GET method");
    });
});
