define('jira/issues/components/filters/views/dialogs/copy', ['require'], function (require) {
    "use strict";

    var SmartAjax = require('jira/ajs/ajax/smart-ajax');
    var _ = require('underscore');
    var wrmContextPath = require('wrm/context-path');
    var Templates = require('jira/issues/components/filters/templates/dialogs');
    var DialogView = require('jira/components/libs/marionette-1.4.1/dialogview');
    var Meta = require('jira/util/data/meta');

    var contextPath = wrmContextPath();

    /**
     * @class JIRA.Components.Filters.Views.Dialogs.Copy
     *
     * @extends JIRA.Marionette.DialogView
     */
    return DialogView.extend({
        template: Templates.Save,

        id: "copy-filter-dialog",

        /**
         * Generate the options needed to display the form, in the format expected by JIRA.FormDialog.
         *
         * @returns {Object}
         */
        dialogOptions: function() {
            var instance = this;
            return {
                content: function(callback) {
                    // Make REST call to see if user shares filters by default
                    SmartAjax.makeRequest({
                        url: contextPath + '/rest/api/2/filter/defaultShareScope',
                        contentType: 'application/json'
                    }).done(function(data) {
                        callback(
                            instance.template(_.extend({
                                isDefaultShareScopeGlobal: data && data.scope === 'GLOBAL'
                            }, instance.serializeData()))
                        );
                    });
                }
            };
        },

        /**
         * Generate the data to be sent in the form request.
         *
         * @param {jQuery} form Form container.
         * @returns {Object} Data to be sent in the request.
         */
        formToRequestData: function(form) {
            return {
                name: form.find('[name=name]').val(),
                id: this.model.getId(),
                favourite: true
            };
        },

        /**
         * Generate the data needed by the template
         *
         * @returns {Object}
         */
        serializeData: function() {
            var model = this.model;
            return {
                headerText: AJS.I18n.getText('issue.nav.filters.copyialog.title') + " : " + model.getName(),
                prefilledFilterName: AJS.I18n.getText('common.words.copyof', model.getName()),
                modifierKey: Meta.get("keyboard-accesskey-modifier"),
                contextPath: contextPath,
                filter: model.toJSON(),
                copyFromAnotherUser: model.getOwnerUserName() !== Meta.get('remote-user'),
                filterOwnerName: model.getOwnerDisplayName(),
                hiddenFields: []
            };
        },

        /**
         * Method to run when the form has been submitted successfully.
         *
         * Changes the user sharing preference to 'PRIVATE' if needed.
         */
        onSubmitSuccess: function() {
            if (this.$el.find('#setSharingPrivate').prop('checked')) {
                SmartAjax.makeRequest({
                    url: contextPath + '/rest/api/2/filter/defaultShareScope',
                    type: 'PUT',
                    contentType: 'application/json',
                    processData: false,
                    data: JSON.stringify({scope: 'PRIVATE'})
                });
            }
        },

        /**
         * Method to run when the form has been submitted with errors
         */
        onSubmitError: function() {
            this.dialog.$form.find("#filterName").focus();
        }
    });
});
