AJS.test.require(["com.atlassian.jira.jira-issue-nav-plugin:filters-component-test"],function(){var c=require("underscore");var d=require("jira/util/data/meta");var b=require("jira/issues/components/filters/entities/filter");var e=require("jira/issues/components/filters/views/dialogs/copy");var a=require("jira/issues/components/testutils");module("jira/issues/components/filters/views/dialogs/copy",{setup:function(){this.server=sinon.fakeServer.create()},teardown:function(){this.server.restore()},renderDialog:function(f,g){f.render();a.moveDialogToQunitFixture(f);c.last(this.server.requests).respond(200,{"Content-Type":"application/json"},JSON.stringify({scope:g||"PRIVATE"}))},submitDialog:function(g,f){var h=g.dialog.$form;f=f||{};if(f.name){h.find("#filterName").val(f.name)}if(f.changeToPrivate){h.find("#setSharingPrivate").prop("checked",true)}h.submit();c.last(this.server.requests).respond(f.responseCode||200)}});test("It should check if the default sharing for the user is GLOBAL",function(){var g=new e({model:new b({name:"test filter"})});this.renderDialog(g);var f=c.last(this.server.requests);ok(f.url.match("/rest/api/2/filter/defaultShareScope"),"Request to the right REST endpoint");equal(f.method,"GET","Request uses GET method")});test("It should display a switch-to-private checkbox If the default sharing for the user is GLOBAL",function(){var f=new e({model:new b({name:"test filter"})});this.renderDialog(f,"GLOBAL");ok(f.dialog.$form.find("#setSharingPrivate:checkbox"),"The form contains a checkbox for sharingPrivate");equal(f.dialog.$form.find("label[for=setSharingPrivate]").text(),"issuenav.filters.sharing.default.changetoprivate","The form contains a text about changing the default share scope to private")});test("It should not display a switch-to-private checkbox If the default sharing for the user is PRIVATE",function(){var f=new e({model:new b({name:"test filter"})});this.renderDialog(f,"PRIVATE");equal(f.dialog.$form.find("#setSharingPrivate:checkbox").length,0,"The form does not contain a checkbox for sharingPrivate")});test("It should pass the name when submitting the form",function(){var f=new e({model:new b({name:"test filter"})});this.renderDialog(f);this.submitDialog(f,{name:"This filter is a copy"});equal(JSON.parse(c.last(this.server.requests).requestBody).name,"This filter is a copy")});test("It should pass the original filter id when submitting the form",function(){var f=new e({model:new b({name:"test filter",id:"1234"})});this.renderDialog(f);this.submitDialog(f);equal(JSON.parse(c.last(this.server.requests).requestBody).id,"1234")});test("It should copy the filter as favourite when submitting the form",function(){var f=new e({model:new b({name:"test filter",id:"1234"})});this.renderDialog(f);this.submitDialog(f);equal(JSON.parse(c.last(this.server.requests).requestBody).favourite,true)});test("It should display the 'Copy' header when rendering the form",function(){var f=new e({model:new b({name:"test filter",id:"1234"})});this.renderDialog(f);equal(f.dialog.$popup.find("h2").text(),"issue.nav.filters.copyialog.title : test filter")});test("It should prefill the filters name with 'Copy of ...'",function(){this.stub(AJS,"format");var f=new e({model:new b({name:"test filter",id:"1234"})});this.renderDialog(f);sinon.assert.calledWith(AJS.format,"common.words.copyof","test filter")});test("It should display a message when copying a filter from another user",function(){this.stub(d,"get").withArgs("remote-user").returns("myUser");this.stub(AJS,"format");var f=new e({model:new b({name:"test filter",id:"1234",ownerUserName:"ownerUser",ownerDisplayName:"Mr. filter's owner"})});this.renderDialog(f);sinon.assert.calledWith(AJS.format,"issue.nav.filters.savedialog.desc.otherowner","Mr. filter's owner")});test("It should change user's default sharing to private when the switch-to-private checkbox is marked",function(){var g=new e({model:new b({name:"test filter",id:"1234"})});this.renderDialog(g,"GLOBAL");this.submitDialog(g,{changeToPrivate:true});var f=c.last(this.server.requests);deepEqual(JSON.parse(f.requestBody),{scope:"PRIVATE"},"Request payload is valid");ok(f.url.match("/rest/api/2/filter/defaultShareScope"),"Request to the right REST endpoint");equal(f.method,"PUT","Request uses PUT method")});test("It should focus the name field when there is an error submitting the form",function(){var f=new e({model:new b({name:"test filter",id:"1234"})});this.renderDialog(f);this.submitDialog(f,{responseCode:500});ok(document.activeElement===f.dialog.$popup.find("#filterName")[0])})});