define('jira/issues/components/filters/views/actions', ['require'], function (require) {
    "use strict";

    var Dropdown = require('jira/ajs/dropdown/dropdown');
    var _ = require('underscore');
    var Templates = require('jira/issues/components/filters/templates/actions');
    var ItemView = require('jira/components/libs/marionette-1.4.1/itemview');
    var LoginUtils = require('jira/issues/utils/login');
    var WindowPositioning = require("jira/issues/layer-positioning/window");
    var AJSHelper = require("jira/issues/libs/ajshelper");

    /**
     * @class JIRA.Components.Filters.Views.Actions
     *
     * Displays the actions dropdown for a filter
     *
     * @extends JIRA.Marionette.ItemView
     */
    return ItemView.extend({
        template: Templates.DropDown,

        triggers: {
            "click .rename-filter": "renameFilter",
            "click .copy-filter": "copyFilter",
            "click .unfavourite-filter": "unfavouriteFilter",
            "click .delete-filter": "deleteFilter"
        },

        /**
         * The view that was used as a trigger for the dropdown. Populated when this view is created.
         * @type {JIRA.Marionette.View}
         */
        triggerView: null,

        /**
         * Internal dropdown created with this view is rendered.
         * @type {AJS.Dropdown}
         */
        dropDown: null,

        /**
         * @param {Object} options Options
         * @param {JIRA.Components.Filters.Views.List.FilterWithActions} options.triggerView View that was used to trigger the dropDown
         */
        initialize: function(options) {
            this.triggerView = options.triggerView;
        },

        serializeData: function() {
            return {
                filter: this.model,
                canEdit: LoginUtils.loggedInUserName() === this.model.getOwnerUserName()
            };
        },

        onBeforeRender: function() {
            this.dropDown = new Dropdown({
                alignment: AJSHelper.LEFT,
                styleClass: "filter-actions-dropdown",
                content: _.bind(function() {
                    return this.$el;
                }, this),
                positioningController: new WindowPositioning(),
                trigger: this.triggerView.getActionsTrigger()
            });

            // When the dropdown is hidden, close this view
            this.dropDown.bind("hideLayer", _.bind(this.close, this));
        },

        onRender: function() {
            this.dropDown.show();
            this._markFilterAsSelected();
        },

        onClose: function() {
            this.dropDown.hide();
            this.dropDown.layerController.placeholder().remove();
            this.dropDown = null;
            this._markFilterAsUnselected();
        },

        _markFilterAsSelected: function() {
            var trigger = this.triggerView.getActionsTrigger();
            trigger.find("span").addClass("active");
            trigger.closest("li").addClass("hover");
        },

        _markFilterAsUnselected: function() {
            var trigger = this.triggerView.getActionsTrigger();
            trigger.find("span").removeClass("active");
            trigger.closest("li").removeClass("hover");
        }
    });
});
