/**
 * This file is used to wrap the templates exported in the global namespace
 * by Google Closure Compile with an AMD module. The goal of this AMD module
 * is to hold a reference to the templates, even when they are removed from
 * the global namespace.
 *
 * Please, note that this AMD can be used only in JavaScript land. Soy templates
 * still have to use the global reference. In other words, if someone removes
 * the global reference, it needs to be restored *before* executing a template.
 */
define("jira/issues/components/filters/templates/actions", function () {
    "use strict";

    return JIRA.Components.Filters.Templates.Actions;
});

define("jira/issues/components/filters/templates/details", function () {
    "use strict";

    return JIRA.Components.Filters.Templates.Details;
});

define("jira/issues/components/filters/templates/dialogs", function () {
    "use strict";

    return JIRA.Components.Filters.Templates.Dialogs;
});

define("jira/issues/components/filters/templates/header", function () {
    "use strict";

    return JIRA.Components.Filters.Templates.Header;
});

define("jira/issues/components/filters/templates/list", function () {
    "use strict";

    return JIRA.Components.Filters.Templates.List;
});

/**
 * Force an execution of the module factory, in order to capture a reference to
 * the templates in the AMD module. This will allow other AMD modules access the
 * templates even if the global reference is removed.
 */
AJS.namespace("JIRA.Components.Filters.Templates.Actions", null, require("jira/issues/components/filters/templates/actions"));
AJS.namespace("JIRA.Components.Filters.Templates.Details", null, require("jira/issues/components/filters/templates/details"));
AJS.namespace("JIRA.Components.Filters.Templates.Dialogs", null, require("jira/issues/components/filters/templates/dialogs"));
AJS.namespace("JIRA.Components.Filters.Templates.Header", null, require("jira/issues/components/filters/templates/header"));
AJS.namespace("JIRA.Components.Filters.Templates.List", null, require("jira/issues/components/filters/templates/list"));
