define('jira/issues/components/filters/entities/system-filters', ['require'], function (require) {
    "use strict";

    var _ = require('underscore');
    var wrmContextPath = require('wrm/context-path');
    var jQuery = require('jquery');
    var Filters = require('jira/issues/components/filters/entities/filters');

    var contextPath = wrmContextPath();

    /**
     * @class JIRA.Components.Filters.Collections.SystemFilters
     *
     * A collection of FilterModel objects.
     *
     * @extends JIRA.Components.Filters.Collections.Filters
     */
    return Filters.extend({

        _setFetchState: function(state) {
            var isNewSate = state !== this.fetchState;

            this.fetchState = state;
            if (isNewSate) {
                this.trigger("change:fetchState", this.fetchState);
            }
        },

        url: contextPath + "/rest/issueNav/latest/systemFilters",

        fetch: function() {
            if (this.length > 0) {
                this._setFetchState("fetched");
                return new jQuery.Deferred().resolve();
            }

            return Filters.prototype.fetch.apply(this, _.toArray(arguments));
        }
    });
});
