define('jira/issues/components/filters/controllers/header', ['require'], function (require) {
    "use strict";

    var Details = require('jira/issues/components/filters/views/details');
    var Header = require('jira/issues/components/filters/views/header');
    var Controller = require('jira/components/libs/marionette-1.4.1/controller');
    var LoginUtils = require('jira/issues/utils/login');

    /**
     * @class JIRA.Components.Filters.Controllers.Header
     *
     * @extends JIRA.Marionette.Controller
     */
    return Controller.extend({
        /**
         * @constructor
         */
        initialize: function() {
            this.view = null;
        },

        close: function() {
            if (this.view) {
                this.view.close();
                this.stopListening(this.view);
                this.view = null;
                this.trigger("close");
            }
        },

        closeDetails: function() {
            if (this.detailsView) {
                this.detailsView.close();
                this.stopListening(this.detailsView);
                this.detailsView = null;
            }
        },

        showDetails: function(triggerEl) {
            if (this.detailsView) {
                this.closeDetails();
            }

            this.detailsView = new Details({
                model: this.model,
                triggerEl: triggerEl
            });
            this.listenTo(this.detailsView, "close", this.closeDetails);

            this.detailsView.render();
        },

        show: function(options) {
            if (this.view) {
                this.close();
            }

            this.view = new Header({
                el: options.el
            });
            this.isInvalid = false;

            this.listenTo(this.view, {
                "saveAs": function(args) {
                    if (!LoginUtils.isLoggedIn() || this.isInvalid) return;
                    this.trigger("saveAs", args.model);
                },
                "save": function(args) {
                    if (!LoginUtils.isLoggedIn() || this.isInvalid) return;
                    this.trigger("save", args.model);
                },
                "discard": function() {
                    this.update({
                        isEdited: false,
                        isDirty: false
                    });
                    this.trigger("discard");
                },
                "details": function(triggerEl) {
                    this.showDetails(triggerEl);
                },
                "toogleFavourite": function(args) {
                    var model = args.model;

                    if (!model) return;

                    var currentlyFavourited = !!model.getFavourite();
                    model.saveFavourite(!currentlyFavourited);
                    // Need to add to the favourite filters collection if a filter has just been starred
                    if (!currentlyFavourited) {
                        this.trigger("favourite", model);
                    }
                },
                "close": this.close
            });

            this.update(options);
        },

        update: function(options) {
            if (!this.view) {
                return;
            }

            if (typeof options.model !== "undefined") {
                this.model = options.model;
            }

            this.isInvalid = false;

            this.view.render({
                model: this.model,
                isDirty: options.isDirty,
                isEdited: options.isEdited
            });

            this.model = options.model;
        },

        markAsInvalid: function() {
            if (this.view) {
                this.view.markAsInvalid();
            }
            this.isInvalid = true;
        }
    });
});
