AJS.test.require(["com.atlassian.jira.jira-issue-nav-plugin:issuenav","com.atlassian.jira.jira-issue-nav-plugin:filters-component-test"],function(){var e=require("jquery");var d=require("jira/message");var a=require("jira/issues/components/filters/entities/filter");var b=require("jira/issues/components/filters");var c=require("jira/issues/search-page-module");module("jira/issues/components/filters",{setup:function(){this.filtersComponent=new b({searchPageModule:new c()});this.server=sinon.fakeServer.create();this.favouriteFiltersCollection=this.filtersComponent.favouriteFiltersCollection;this.systemFiltersCollection=this.filtersComponent.systemFiltersCollection;sinon.stub(d,"showSuccessMsg")},teardown:function(){d.showSuccessMsg.restore()},mockFilterRequest:function(f){this.server.respondWith("GET",new RegExp("/rest/api/2/filter/(\\d+)"),[200,{"Content-Type":"application/json"},JSON.stringify(f)])},requestFilter:function(f){var g=this.requestFilterWithoutServerResponse(f);this.server.respond();return g},requestFilterWithoutServerResponse:function(g){var h=this.spy();var f=this.filtersComponent.getFilterById(g);f.done(h);return h}});test("It loads a filter model from the network",function(){this.mockFilterRequest({id:101,name:"the fake filter"});var f=this.requestFilter(101);sinon.assert.calledOnce(f);equal(f.getCall(0).args[0] instanceof a,true,"should be a filter model");equal(f.getCall(0).args[0].get("name"),"the fake filter","returned data for our fake filter")});test("If the filter is favourite, it adds it to the favourites collection",function(){this.mockFilterRequest({id:101,favourite:true});this.requestFilter(101);equal(this.favouriteFiltersCollection.length,1,"There is one filter in the collection");ok(this.favouriteFiltersCollection.get(101) instanceof a,"The fake filter is in the collection")});test("If the filter is system, it adds it to the system collection",function(){this.mockFilterRequest({id:101,isSystem:true});this.requestFilter(101);equal(this.systemFiltersCollection.length,1,"There is one filter in the collection");ok(this.systemFiltersCollection.get(101) instanceof a,"The fake filter is in the collection")});test("If the filter is already in the favourites collection, it returns the filter from the collection",function(){this.favouriteFiltersCollection.add({id:101,name:"my filter",favourite:true});var f=this.requestFilter(101);equal(f.getCall(0).args[0],this.favouriteFiltersCollection.get(101))});test("If the filter is already in the system collection, it returns the filter from the collection",function(){this.systemFiltersCollection.add({id:101,name:"my filter",isSystem:true});var f=this.requestFilter(101);equal(f.getCall(0).args[0],this.systemFiltersCollection.get(101))});test("If the filter appears on the favourite collection while it was being requested, it merges the new data with the data already present in the collection",function(){var f={id:101,favourite:true};this.mockFilterRequest({id:101,name:"my filter",favourite:true});var g=this.requestFilterWithoutServerResponse(101);this.favouriteFiltersCollection.add(f);this.server.respond();sinon.assert.calledOnce(g);equal(g.getCall(0).args[0] instanceof a,true,"should be a filter model");equal(g.getCall(0).args[0].get("name"),"my filter","returned data for our fake filter")});test("If the filter appears on the system collection while it was being requested, it merges the new data with the data already present in the collection",function(){var f={id:101,isSystem:true};this.mockFilterRequest({id:101,name:"my filter",isSystem:true});var g=this.requestFilterWithoutServerResponse(101);this.systemFiltersCollection.add(f);this.server.respond();sinon.assert.calledOnce(g);equal(g.getCall(0).args[0] instanceof a,true,"should be a filter model");equal(g.getCall(0).args[0].get("name"),"my filter","returned data for our fake filter")});test("It raises a 'filterUnfavourited' event when a filter is removed from the favourites collection",function(){var g={id:101,favourite:true};this.favouriteFiltersCollection.add(g);var f=this.spy();this.filtersComponent.on("filterUnfavourited",f);this.favouriteFiltersCollection.remove(101);sinon.assert.calledOnce(f);sinon.assert.calledWith(f,{filterId:101})});test("It deletes a filter form the collection when the DeleteDialog is successfully submitted",function(){var f={id:101,name:"My fake filter"};this.favouriteFiltersCollection.add(f);this.filtersComponent.dialogController.trigger("delete:success",this.favouriteFiltersCollection.get(101));equal(this.favouriteFiltersCollection.length,0)});test("It raises two events, 'filterRemoved' and 'filterUnfavourited', when the DeleteDialog is successfully submitted",function(){var g={id:1001,name:"Other fake filter"};this.favouriteFiltersCollection.add(g);var h=this.spy();var f=this.spy();this.filtersComponent.on("filterRemoved",h);this.filtersComponent.on("filterUnfavourited",f);this.filtersComponent.dialogController.trigger("delete:success",this.favouriteFiltersCollection.get(1001));sinon.assert.calledOnce(h);sinon.assert.calledWith(h,{filterId:1001});sinon.assert.calledOnce(f);sinon.assert.calledWith(f,{filterId:1001})});test("It triggers a 'filterSelected' event when a system filter is selected",function(){var g=this.spy();var f=new a({id:100});this.filtersComponent.on("filterSelected",g);this.filtersComponent.systemFiltersController.trigger("selectFilter",f);sinon.assert.calledOnce(g);sinon.assert.calledWith(g,100)});test("Marking a filter as favourite from the header, saves it in the favourites collection",function(){var f=new a({id:"1",name:"a filter",favourite:true});this.filtersComponent.headerController.trigger("favourite",f);ok(this.filtersComponent.favouriteFiltersCollection.contains(f),"The filter is added to the favourites collection")});test("Marking a filter as favourite from the header, it is marked as active",function(){var f=new a({id:"1",name:"a filter",favourite:true});this.spy(this.filtersComponent,"highlightFilter");this.filtersComponent.headerController.trigger("favourite",f);sinon.assert.calledOnce(this.filtersComponent.highlightFilter);sinon.assert.calledWith(this.filtersComponent.highlightFilter,f)});test("When saving a filter, it throws the 'savedFilter' event with the model as argument",function(){var g=new a({id:"1",name:"a filter",favourite:true});this.stub(g,"saveFilter").returns(new e.Deferred().resolve().promise());var f=this.spy();this.filtersComponent.on("savedFilter",f);this.filtersComponent.headerController.trigger("save",g);sinon.assert.calledOnce(f);sinon.assert.calledWith(f,g)});test("When saving a filter, it shows a successful message",function(){var f=new a({id:"1",name:"a filter",favourite:true});this.stub(f,"saveFilter").returns(new e.Deferred().resolve().promise());this.filtersComponent.headerController.trigger("save",f);sinon.assert.calledOnce(d.showSuccessMsg);sinon.assert.calledWith(d.showSuccessMsg,"issuenav.filters.save.success.msg")})});