AJS.test.require(["com.atlassian.jira.jira-issue-nav-plugin:backbone-ext"], function () {
    "use strict";

    require([
        "jira/issues/basemodel"
    ], function(
        BaseModel
    ) {
        test("Getter and setter are added to model", function () {
            var MaleModel = BaseModel.extend({
                properties: ["look"]
            });

            var zoolander = new MaleModel();

            ok(zoolander.getLook);
            ok(zoolander.setLook);

            zoolander.setLook("Blue Steel");
            equal(zoolander.get("look"), "Blue Steel");

            equal(zoolander.getLook(), "Blue Steel");
        });

        test("ID property is always added to properties", function () {
            var MaleModel = BaseModel.extend({
                properties: ["look"]
            });

            var zoolander = new MaleModel();

            deepEqual(zoolander.properties, ["id", "look"]);
            ok(zoolander.getId);
            ok(zoolander.setId);
        });

        test("Does not barf when user specifies id", function () {
            var MaleModel = BaseModel.extend({
                properties: ["id", "look"]
            });

            var zoolander = new MaleModel();

            deepEqual(zoolander.properties, ["id", "look"]);
            ok(zoolander.getId);
            ok(zoolander.setId);
        });

        test("ID property is not added if model does not specify properties", function () {
            var MaleModel = BaseModel.extend();

            var zoolander = new MaleModel();

            ok(!zoolander.properties);
            ok(!zoolander.getId);
            ok(!zoolander.setId);
        });

        test("Setting properties that does not exist fails", function () {
            var MaleModel = BaseModel.extend({
                properties: ["look"]
            });

            var zoolander = new MaleModel();
            raises(function () {
                zoolander.set({
                    mer: "man"
                });
            });
        });

        test("Setting property that does not exist fails", function () {
            var MaleModel = BaseModel.extend({
                properties: ["look"]
            });

            var zoolander = new MaleModel();
            raises(function () {
                zoolander.set("mer", "man");
            });
        });

        test("Getting property that does not exist fails", function () {
            var MaleModel = BaseModel.extend({
                properties: ["look"]
            });

            var zoolander = new MaleModel();
            raises(function () {
                zoolander.get("eugooglize");
            });
        });

        test("Setting any property when no property exists succeeds", function () {
            var MaleModel = BaseModel.extend();
            var hansel = new MaleModel();
            hansel.set("derelique");
            equal(hansel.get("derelique"), undefined, 'Value undefined returned for key "derelique"');
        });

        test("Getting any property when no property exists succeeds", function () {
            var MaleModel = BaseModel.extend();
            var hansel = new MaleModel();
            equal(hansel.get("derelique"), undefined, 'Value undefined returned for key "derelique"');
        });

        test("Mixin can apply properties to model with no properties", function () {
            var MyMixin = {
                properties: ["someProperty"]
            };
            var MyModel = BaseModel.extend({
                mixins: [MyMixin]
            });
            var myModel = new MyModel();
            deepEqual(myModel.properties, ["id", "someProperty"]);
            ok(myModel.getSomeProperty);
            ok(myModel.setSomeProperty);
        });

        test("Mixin can apply properties to model with some properties", function () {
            var MyMixin = {
                properties: ["someProperty"]
            };
            var MyModel = BaseModel.extend({
                mixins: [MyMixin],
                properties: ["someOtherProperty"]
            });
            var myModel = new MyModel();
            deepEqual(myModel.properties, ["id", "someOtherProperty", "someProperty"]);
            ok(myModel.getSomeOtherProperty);
            ok(myModel.setSomeOtherProperty);
            ok(myModel.getSomeProperty);
            ok(myModel.setSomeProperty);
        });
    });
});
