/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuenav.util;

import com.atlassian.jira.components.issueviewer.service.SystemFilter;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.issuenav.Search;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.query.Query;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class DefaultSearchUtil {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final SearchProvider searchProvider;
    private final UserProjectHistoryManager userProjectHistoryManager;

    @Inject
    public DefaultSearchUtil(JiraAuthenticationContext jiraAuthenticationContext, SearchProvider searchProvider, UserProjectHistoryManager userProjectHistoryManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.searchProvider = searchProvider;
        this.userProjectHistoryManager = userProjectHistoryManager;
    }

    public Search getSearch() {
        if (this.currentUserHasOpenIssues()) {
            return new Search(SystemFilter.MY_OPEN_ISSUES);
        }
        Project currentProject = this.getCurrentProject();
        if (currentProject != null && this.projectHasIssues(currentProject)) {
            return new Search(null, "project = " + currentProject.getKey());
        }
        return new Search(SystemFilter.ALL_ISSUES);
    }

    private Project getCurrentProject() {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        return this.userProjectHistoryManager.getCurrentProject(10, user);
    }

    private boolean currentUserHasOpenIssues() {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        if (user != null) {
            try {
                Query query = this.getOpenIssuesQuery();
                return this.searchProvider.searchCount(query, user) > 0L;
            }
            catch (SearchException searchException) {
                // empty catch block
            }
        }
        return false;
    }

    protected Query getOpenIssuesQuery() {
        String username = this.jiraAuthenticationContext.getLoggedInUser().getName();
        return JqlQueryBuilder.newBuilder().where().assigneeUser(username).and().unresolved().buildQuery();
    }

    protected Query getProjectQuery(Project project) {
        return JqlQueryBuilder.newBuilder().where().project(new String[]{project.getKey()}).buildQuery();
    }

    private boolean projectHasIssues(Project project) {
        try {
            ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
            Query query = this.getProjectQuery(project);
            return this.searchProvider.searchCount(query, user) > 0L;
        }
        catch (SearchException e) {
            return false;
        }
    }
}

