/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuenav.service.issuetable;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.components.orderby.OrderByUtil;
import com.atlassian.jira.components.util.SortJqlGenerator;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.plugin.issuenav.service.issuetable.AbstractIssueTableCreator;
import com.atlassian.jira.plugin.issuenav.service.issuetable.IssueTableServiceConfiguration;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.component.IssuePager;
import com.atlassian.jira.web.component.IssueTableLayoutBean;
import com.atlassian.jira.web.component.IssueTableWebComponent;
import com.atlassian.query.Query;
import java.util.Collection;
import java.util.List;

class ListViewIssueTableCreator
extends AbstractIssueTableCreator {
    public ListViewIssueTableCreator(ApplicationProperties applicationProperties, ColumnLayoutManager columnLayoutManager, IssueTableServiceConfiguration configuration, boolean fromIssueIds, IssueFactory issueFactory, List<Long> issueIds, SortJqlGenerator sortJqlGenerator, Query query, boolean returnIssueIds, SearchHandlerManager searchHandlerManager, SearchProvider searchProvider, SearchProviderFactory searchProviderFactory, SearchRequest searchRequest, SearchService searchService, ApplicationUser user, FieldManager fieldManager, OrderByUtil orderByUtil) {
        super(applicationProperties, columnLayoutManager, configuration, fromIssueIds, issueFactory, issueIds, sortJqlGenerator, query, returnIssueIds, searchHandlerManager, searchProvider, searchProviderFactory, searchRequest, searchService, user, fieldManager, orderByUtil);
    }

    @Override
    protected Object getTable() {
        if (this.searchResults.getIssues().isEmpty()) {
            return null;
        }
        SearchResults issuePager = this.configuration.isPaging() ? this.searchResults : null;
        return new IssueTableWebComponent().getHtml(this.createLayout(), this.searchResults.getIssues(), (IssuePager)issuePager);
    }

    private IssueTableLayoutBean createLayout() {
        List<ColumnLayoutItem> displayedColumns = this.getDisplayedColumns(this.configuration.getColumnNames());
        IssueTableLayoutBean layout = new IssueTableLayoutBean(displayedColumns, (Collection)this.query.getOrderByClause().getSearchSorts());
        layout.addCellDisplayParam("navigator_view", (Object)Boolean.TRUE);
        layout.setDisplayHeader(this.configuration.isDisplayHeader());
        layout.setDisplayHeaderPager(false);
        layout.setShowActionColumn(this.configuration.isShowActions());
        layout.setShowExteriorTable(false);
        layout.setSortingEnabled(this.configuration.isEnableSorting());
        layout.setTableCssClass("grid issuetable-db maxWidth");
        return layout;
    }
}

