/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuenav.service.issuetable;

import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItemImpl;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutStorageException;
import com.atlassian.jira.issue.fields.layout.column.UserColumnLayoutImpl;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.plugin.issuenav.service.issuetable.IssueTableServiceConfiguration;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import java.util.List;

class DisplayedColumnsHelper {
    private final ColumnLayoutManager columnLayoutManager;
    private final FieldManager fieldManager;

    DisplayedColumnsHelper(ColumnLayoutManager columnLayoutManager, FieldManager fieldManager) {
        this.columnLayoutManager = columnLayoutManager;
        this.fieldManager = fieldManager;
    }

    ColumnLayout getDisplayedColumns(ApplicationUser user, SearchRequest searchRequest, IssueTableServiceConfiguration configuration) {
        try {
            ColumnLayout.ColumnConfig config = configuration.getColumnConfig();
            boolean filterRequested = searchRequest.isLoaded();
            List<String> columnNames = configuration.getColumnNames();
            Object columnLayout = columnNames != null ? this.getDisplayedColumns(user, columnNames) : (filterRequested && (config == ColumnLayout.ColumnConfig.FILTER || config == null) ? this.columnLayoutManager.getColumnLayout(user, searchRequest) : (config == ColumnLayout.ColumnConfig.SYSTEM ? this.columnLayoutManager.getEditableDefaultColumnLayout() : this.columnLayoutManager.getColumnLayout(user)));
            return columnLayout;
        }
        catch (ColumnLayoutStorageException e) {
            throw new RuntimeException("Exception thrown while retrieving columns for issue table", e);
        }
    }

    ColumnLayout getDisplayedColumns(ApplicationUser user, List<String> columnNames) {
        ArrayList<ColumnLayoutItemImpl> columnLayoutItems = new ArrayList<ColumnLayoutItemImpl>();
        int pos = 0;
        for (String id : columnNames) {
            if (!this.fieldManager.isNavigableField(id)) continue;
            columnLayoutItems.add(new ColumnLayoutItemImpl(this.fieldManager.getNavigableField(id), pos));
            ++pos;
        }
        return new UserColumnLayoutImpl(columnLayoutItems, user, ColumnLayout.ColumnConfig.EXPLICIT);
    }
}

