/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuenav.service.issuetable;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.components.util.FilterLookerUpper;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.index.SearchUnavailableException;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.jql.ClauseInformation;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.util.JqlCustomFieldId;
import com.atlassian.jira.plugin.issuenav.service.issuetable.IssueTable;
import com.atlassian.jira.plugin.issuenav.service.issuetable.IssueTableCreator;
import com.atlassian.jira.plugin.issuenav.service.issuetable.IssueTableCreatorFactory;
import com.atlassian.jira.plugin.issuenav.service.issuetable.IssueTableService;
import com.atlassian.jira.plugin.issuenav.service.issuetable.IssueTableServiceConfiguration;
import com.atlassian.jira.plugin.issuenav.service.issuetable.IssueTableServiceOutcome;
import com.atlassian.jira.plugin.issuenav.util.PreferredSearchLayoutService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.query.Query;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.OrderByImpl;
import com.atlassian.query.order.SearchSort;
import com.atlassian.query.order.SortOrder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@ExportAsService
@Named
public class DefaultIssueTableService
implements IssueTableService {
    private static final Logger log = Logger.getLogger(DefaultIssueTableService.class);
    private static final String COLUMN_NAMES = "columnNames";
    private static final int MAX_JQL_ERRORS = 10;
    private final JiraAuthenticationContext authenticationContext;
    private final FieldManager fieldManager;
    private final IssueTableCreatorFactory issueTableCreatorFactory;
    private final PreferredSearchLayoutService preferredSearchLayoutService;
    private final SearchService searchService;
    private final SearchSortUtil searchSortUtil;
    private final SearchHandlerManager searchHandlerManager;
    private final FilterLookerUpper filterLookerUpper;

    @Inject
    public DefaultIssueTableService(JiraAuthenticationContext jiraAuthenticationContext, FieldManager fieldManager, IssueTableCreatorFactory issueTableCreatorFactory, PreferredSearchLayoutService preferredSearchLayoutService, FilterLookerUpper filterLookerUpper, SearchService searchService, SearchSortUtil searchSortUtil, SearchHandlerManager searchHandlerManager) {
        this.authenticationContext = jiraAuthenticationContext;
        this.fieldManager = fieldManager;
        this.issueTableCreatorFactory = issueTableCreatorFactory;
        this.preferredSearchLayoutService = preferredSearchLayoutService;
        this.searchService = searchService;
        this.searchSortUtil = searchSortUtil;
        this.searchHandlerManager = searchHandlerManager;
        this.filterLookerUpper = filterLookerUpper;
    }

    @Override
    public ServiceOutcome<IssueTableServiceOutcome> getIssueTableFromFilterWithJql(String filterId, String jql, IssueTableServiceConfiguration configuration, boolean returnMatchingIssueIds) {
        if (null == filterId) {
            return this.getIssueTableFromJQL(jql, configuration, returnMatchingIssueIds);
        }
        if (null == jql) {
            return this.getIssueTableFromFilter(filterId, configuration, returnMatchingIssueIds);
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        SearchRequest searchRequest = this.filterLookerUpper.getSearchRequestFromFilterId(filterId, (ErrorCollection)errorCollection);
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        SearchService.ParseResult parseResult = this.searchService.parseQuery(user, jql);
        if (!parseResult.isValid()) {
            return this.buildJQLErrorServiceOutcome(parseResult.getErrors());
        }
        return this.getIssueTable(configuration, parseResult.getQuery(), returnMatchingIssueIds, searchRequest);
    }

    @Override
    public ServiceOutcome<IssueTableServiceOutcome> getIssueTableFromIssueIds(String filterId, String jql, List<Long> ids, IssueTableServiceConfiguration configuration) {
        SearchRequest searchRequest;
        if (filterId != null) {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            searchRequest = this.filterLookerUpper.getSearchRequestFromFilterId(filterId, (ErrorCollection)errorCollection);
            if (errorCollection.hasAnyErrors()) {
                return new ServiceOutcomeImpl((ErrorCollection)errorCollection);
            }
        } else {
            searchRequest = new SearchRequest();
        }
        Query query = null;
        if (jql != null) {
            SearchService.ParseResult parseResult = this.searchService.parseQuery(this.authenticationContext.getLoggedInUser(), jql);
            query = parseResult.isValid() ? parseResult.getQuery() : null;
        }
        this.setPreferredLayoutKey(configuration);
        return this.createIssueTableFromCreator(this.issueTableCreatorFactory.getStableIssueTableCreator(configuration, query, ids, searchRequest, this.authenticationContext.getLoggedInUser()));
    }

    ServiceOutcome<IssueTableServiceOutcome> createIssueTableFromCreator(IssueTableCreator creator) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        try {
            MessageSet validationResult = creator.validate();
            if (validationResult.hasAnyErrors()) {
                return this.buildJQLErrorServiceOutcome(validationResult);
            }
            IssueTable issueTable = creator.create();
            Set warnings = validationResult.getWarningMessages();
            return new ServiceOutcomeImpl((ErrorCollection)errorCollection, (Object)new IssueTableServiceOutcome(issueTable, warnings));
        }
        catch (SearchUnavailableException e) {
            if (!e.isIndexingEnabled()) {
                String message = this.authenticationContext.getI18nHelper().getText("gadget.common.indexing.admin");
                errorCollection.addErrorMessage(message);
            } else {
                log.error((Object)e);
                String message = this.authenticationContext.getI18nHelper().getText("unknown.search.error");
                errorCollection.addErrorMessage(message);
            }
        }
        catch (SearchException e) {
            log.error((Object)e);
            String message = this.authenticationContext.getI18nHelper().getText("unknown.search.error");
            errorCollection.addErrorMessage(message);
        }
        return new ServiceOutcomeImpl((ErrorCollection)errorCollection);
    }

    ServiceOutcome<IssueTableServiceOutcome> getIssueTableFromJQL(String jql, IssueTableServiceConfiguration configuration, boolean returnMatchingIssueIds) {
        SearchService.ParseResult parseResult = this.searchService.parseQuery(this.authenticationContext.getLoggedInUser(), jql);
        if (!parseResult.isValid()) {
            return this.buildJQLErrorServiceOutcome(parseResult.getErrors());
        }
        SearchRequest searchRequest = new SearchRequest(parseResult.getQuery());
        return this.getIssueTable(configuration, parseResult.getQuery(), returnMatchingIssueIds, searchRequest);
    }

    ServiceOutcome<IssueTableServiceOutcome> getIssueTableFromFilter(String filterId, IssueTableServiceConfiguration configuration, boolean returnMatchingIssueIds) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        SearchRequest searchRequest = this.filterLookerUpper.getSearchRequestFromFilterId(filterId, (ErrorCollection)errorCollection);
        if (errorCollection.hasAnyErrors()) {
            return new ServiceOutcomeImpl((ErrorCollection)errorCollection);
        }
        return this.getIssueTable(configuration, searchRequest.getQuery(), returnMatchingIssueIds, searchRequest);
    }

    private ServiceOutcome<IssueTableServiceOutcome> buildJQLErrorServiceOutcome(MessageSet messageSet) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        Iterable errorMessages = Iterables.limit((Iterable)messageSet.getErrorMessages(), (int)10);
        for (String error : errorMessages) {
            errors.addErrorMessage(error);
        }
        if (!errors.hasAnyErrors()) {
            errors.addErrorMessage(this.authenticationContext.getI18nHelper().getText("jql.parse.unknown.no.pos"));
        }
        return new ServiceOutcomeImpl((ErrorCollection)errors);
    }

    ServiceOutcome<IssueTableServiceOutcome> getIssueTable(IssueTableServiceConfiguration configuration, Query query, boolean returnIssueIds, SearchRequest searchRequest) {
        if (searchRequest == null) {
            searchRequest = new SearchRequest(query);
        }
        Query queryWithOrderBy = this.addOrderByToSearchRequest(query, configuration.getSortBy());
        this.setPreferredLayoutKey(configuration);
        return this.createIssueTableFromCreator(this.issueTableCreatorFactory.getNormalIssueTableCreator(configuration, queryWithOrderBy, returnIssueIds, searchRequest, this.authenticationContext.getLoggedInUser()));
    }

    @VisibleForTesting
    OrderBy buildOrderBy(OrderBy orderBy, final NavigableField field) {
        String columnName;
        final boolean isCustomField = field instanceof CustomField;
        if (isCustomField) {
            CustomField customField = (CustomField)field;
            columnName = JqlCustomFieldId.toString((long)customField.getIdAsLong());
        } else {
            Collection jqlClauseNames = this.searchHandlerManager.getJqlClauseNames(field.getId());
            columnName = !jqlClauseNames.isEmpty() ? ((ClauseNames)jqlClauseNames.iterator().next()).getPrimaryName() : field.getId();
        }
        ArrayList searchSorts = Lists.newArrayList((Iterable)orderBy.getSearchSorts());
        final ClauseInformation clauseInformation = SystemSearchConstants.getClauseInformationById((String)columnName);
        SearchSort matchingSearchSort = (SearchSort)Iterables.find((Iterable)searchSorts, (Predicate)new Predicate<SearchSort>(){

            public boolean apply(SearchSort searchSort) {
                String fieldInSearch = searchSort.getField();
                return !isCustomField && clauseInformation != null && clauseInformation.getJqlClauseNames().contains(fieldInSearch) || fieldInSearch.equals(columnName) || isCustomField && ((CustomField)field).getFieldName().equals(fieldInSearch);
            }
        }, null);
        SortOrder defaultSortOrder = SortOrder.parseString((String)field.getDefaultSortOrder());
        if (matchingSearchSort != null) {
            boolean isFirstSort = searchSorts.indexOf(matchingSearchSort) == 0;
            SortOrder oldSortOrder = matchingSearchSort.getSortOrder() == null ? defaultSortOrder : matchingSearchSort.getSortOrder();
            SortOrder newSortOrder = isFirstSort ? DefaultIssueTableService.reverseSortOrder(oldSortOrder) : defaultSortOrder;
            searchSorts.remove(matchingSearchSort);
            searchSorts.add(0, new SearchSort(matchingSearchSort.getField(), newSortOrder));
        } else {
            searchSorts.add(0, new SearchSort(columnName, defaultSortOrder));
        }
        return new OrderByImpl((Collection)searchSorts);
    }

    private static SortOrder reverseSortOrder(SortOrder sortOrder) {
        return sortOrder == SortOrder.ASC ? SortOrder.DESC : SortOrder.ASC;
    }

    Query addOrderByToSearchRequest(Query preOrderByQuery, String sortBy) {
        if (StringUtils.isNotBlank((String)sortBy)) {
            String sortDirection = null;
            if (sortBy.endsWith(":DESC") || sortBy.endsWith(":ASC")) {
                sortDirection = sortBy.substring(sortBy.lastIndexOf(58) + 1);
                sortBy = sortBy.substring(0, sortBy.lastIndexOf(58));
            }
            JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder((Query)preOrderByQuery);
            String[] sortArray = new String[]{sortDirection};
            String[] fieldArray = new String[]{sortBy};
            MapBuilder builder = MapBuilder.newBuilder();
            Map params = builder.add((Object)"sorter/order", (Object)sortArray).add((Object)"sorter/field", (Object)fieldArray).toMap();
            OrderBy newOrder = this.searchSortUtil.getOrderByClause(params);
            OrderBy oldOrder = queryBuilder.orderBy().buildOrderBy();
            ApplicationUser user = this.authenticationContext.getLoggedInUser();
            List newSearchSorts = newOrder.getSearchSorts();
            List oldSearchSorts = oldOrder.getSearchSorts();
            List sorts = this.searchSortUtil.mergeSearchSorts(user, (Collection)newSearchSorts, (Collection)oldSearchSorts, 3);
            queryBuilder.orderBy().setSorts((Collection)sorts);
            return queryBuilder.buildQuery();
        }
        return preOrderByQuery;
    }

    void validateColumnNames(List<String> columnNames, ErrorCollection errors) {
        if (columnNames != null && !columnNames.isEmpty()) {
            try {
                ArrayList<String> fieldsNotFound = new ArrayList<String>();
                ApplicationUser user = this.authenticationContext.getLoggedInUser();
                Set availableFields = this.fieldManager.getAvailableNavigableFields(user);
                for (String columnName : columnNames) {
                    if ("--default--".equalsIgnoreCase(columnName)) continue;
                    boolean found = false;
                    for (NavigableField availableField : availableFields) {
                        if (!columnName.equals(availableField.getId())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    fieldsNotFound.add(columnName);
                }
                if (!fieldsNotFound.isEmpty()) {
                    String fieldsNotFoundString = StringUtils.join(fieldsNotFound, (String)", ");
                    errors.addError(COLUMN_NAMES, this.authenticationContext.getI18nHelper().getText("issue.table.service.invalid.columns", fieldsNotFoundString));
                }
            }
            catch (FieldException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void setPreferredLayoutKey(IssueTableServiceConfiguration configuration) {
        if (configuration.getLayoutKey() == null) {
            configuration.setLayoutKey(this.preferredSearchLayoutService.getPreferredSearchLayout());
        }
    }
}

