/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuenav.rest;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@Path(value="saveFilter")
public class SaveFilterResource {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final SearchRequestService searchRequestService;
    private final SearchService searchService;

    public SaveFilterResource(JiraAuthenticationContext jiraAuthenticationContext, SearchRequestService searchRequestService, SearchService searchService) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.searchRequestService = searchRequestService;
        this.searchService = searchService;
    }

    @POST
    @RequiresXsrfCheck
    public Response set(@FormParam(value="jql") String filterJql, @FormParam(value="name") String filterName) {
        try {
            ApplicationUser user = this.jiraAuthenticationContext.getUser();
            if (user == null) {
                return SaveFilterResource.fail(Response.Status.UNAUTHORIZED);
            }
            SearchRequest filterQuery = new SearchRequest(this.searchService.parseQuery(user, filterJql).getQuery());
            filterQuery.setName(filterName);
            filterQuery.setOwner(user);
            SearchRequest newSearchRequest = this.searchRequestService.createFilter((JiraServiceContext)new JiraServiceContextImpl(user), filterQuery, true);
            return SaveFilterResource.createResponse(newSearchRequest);
        }
        catch (Exception e) {
            return SaveFilterResource.fail(Response.Status.BAD_REQUEST);
        }
    }

    private static Response createResponse(SearchRequest searchRequest) {
        return Response.ok((Object)searchRequest).cacheControl(CacheControl.never()).build();
    }

    private static Response fail(Response.Status status) {
        return Response.status((Response.Status)status).cacheControl(CacheControl.never()).build();
    }
}

