/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuenav.rest;

import com.atlassian.jira.plugin.issuenav.util.PreferredSearchLayoutService;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Path(value="preferredSearchLayout")
public class PreferredSearchLayoutResource {
    private final PreferredSearchLayoutService preferredSearchLayoutService;

    public PreferredSearchLayoutResource(PreferredSearchLayoutService preferredSearchLayoutService) {
        this.preferredSearchLayoutService = preferredSearchLayoutService;
    }

    @GET
    public Response get() {
        String preferredLayout = this.preferredSearchLayoutService.getPreferredSearchLayout();
        return Response.ok((Object)preferredLayout).cacheControl(CacheControl.never()).build();
    }

    @POST
    @RequiresXsrfCheck
    public Response set(@FormParam(value="layoutKey") String layoutKey) {
        this.preferredSearchLayoutService.setPreferredSearchLayout(layoutKey);
        return Response.ok().cacheControl(CacheControl.never()).build();
    }
}

