/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuenav.rest;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.components.issueviewer.service.SessionSearchService;
import com.atlassian.jira.components.issueviewer.service.SystemFilter;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.plugin.issuenav.rest.Responses;
import com.atlassian.jira.plugin.issuenav.service.StableSearchResultBean;
import com.atlassian.jira.plugin.issuenav.service.StableSearchService;
import com.atlassian.jira.plugin.issuenav.service.issuetable.IssueTableService;
import com.atlassian.jira.plugin.issuenav.service.issuetable.IssueTableServiceConfiguration;
import com.atlassian.jira.plugin.issuenav.service.issuetable.IssueTableServiceOutcome;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.ExtendedPreferences;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Path(value="issueTable")
@ExportAsService
@Named
public class IssueTableResource {
    private final JiraAuthenticationContext authContext;
    private final IssueTableService issueTableService;
    private final UserPreferencesManager preferencesManager;
    private final SearchRequestService searchRequestService;
    private final SearchService searchService;
    private final SessionSearchService sessionSearchService;
    private final StableSearchService stableSearchService;
    private final UserPreferencesManager userPreferencesManager;

    @Inject
    public IssueTableResource(JiraAuthenticationContext authContext, IssueTableService issueTableService, UserPreferencesManager preferencesManager, SearchRequestService searchRequestService, SearchService searchService, StableSearchService stableSearchService, SessionSearchService sessionSearchService, UserPreferencesManager userPreferencesManager) {
        this.authContext = authContext;
        this.issueTableService = issueTableService;
        this.preferencesManager = preferencesManager;
        this.searchRequestService = searchRequestService;
        this.searchService = searchService;
        this.stableSearchService = stableSearchService;
        this.sessionSearchService = sessionSearchService;
        this.userPreferencesManager = userPreferencesManager;
    }

    @POST
    @RequiresXsrfCheck
    @Produces(value={"application/json"})
    public Response getIssueTableHtml(@FormParam(value="filterId") Long filterId, @FormParam(value="jql") String jql, @FormParam(value="num") String numberToShow, @FormParam(value="startIndex") @DefaultValue(value="0") int startIndex, @FormParam(value="layoutKey") String layoutKey, @FormParam(value="columnConfig") String columnConfig) {
        if (filterId == null && jql == null) {
            return Responses.error();
        }
        if (this.userCanSeeFilter(filterId)) {
            IssueTableServiceConfiguration config;
            String filterString = filterId != null ? filterId.toString() : "";
            ServiceOutcome<IssueTableServiceOutcome> outcome = this.issueTableService.getIssueTableFromFilterWithJql(filterString, jql, config = this.buildConfiguration(layoutKey, numberToShow, startIndex, null, columnConfig), true);
            if (outcome.isValid()) {
                this.sessionSearchService.setSessionSearch(jql, filterId, startIndex, config.getNumberToShow());
                return Response.ok((Object)outcome.getReturnedValue()).cacheControl(CacheControl.never()).build();
            }
            return Responses.error(outcome);
        }
        return this.buildPrivateFilterResponse();
    }

    @Path(value="stable")
    @POST
    @RequiresXsrfCheck
    @Produces(value={"application/json"})
    public Response getIssueTableHtml(@FormParam(value="id") List<Long> ids, @FormParam(value="jql") String jql, @FormParam(value="filterId") String filterId, @FormParam(value="layoutKey") String layoutKey, @FormParam(value="columns") List<String> columns, @FormParam(value="columnConfig") String columnConfig) {
        IssueTableServiceConfiguration config = this.buildConfiguration(layoutKey, String.valueOf(ids.size()), 0, columns, columnConfig);
        ServiceOutcome<StableSearchResultBean> outcome = this.stableSearchService.getIssueTableFromIssueIds(filterId, jql, ids, config);
        if (outcome.isValid()) {
            return Response.ok((Object)outcome.getReturnedValue()).cacheControl(CacheControl.never()).build();
        }
        return Responses.error(outcome);
    }

    @PUT
    @Path(value="sessionSearch")
    @Produces(value={"application/json"})
    public Response setSessionSearch(@FormParam(value="filterId") Long filterId, @FormParam(value="jql") String jql) {
        if (filterId != null) {
            ApplicationUser user = this.authContext.getLoggedInUser();
            SearchRequest filter = this.searchRequestService.getFilter((JiraServiceContext)new JiraServiceContextImpl(user), filterId);
            if (filter == null) {
                return Responses.error();
            }
            if (jql != null) {
                SearchService.ParseResult result = this.searchService.parseQuery(user, jql);
                if (!result.isValid()) {
                    return Responses.error();
                }
                if (filter.getQuery().equals(result.getQuery())) {
                    jql = null;
                }
            }
        }
        this.sessionSearchService.setSessionSearch(jql, filterId, this.getPageStart(), this.getPageSize());
        return Response.ok().build();
    }

    private int getPageSize() {
        ExtendedPreferences preferences = this.userPreferencesManager.getExtendedPreferences(this.authContext.getUser());
        if (preferences != null) {
            return (int)preferences.getLong("user.issues.per.page");
        }
        return 0;
    }

    private int getPageStart() {
        PagerFilter pagerFilter = this.sessionSearchService.getPagerFilter();
        return pagerFilter != null ? pagerFilter.getStart() : 0;
    }

    private IssueTableServiceConfiguration createConfig(String layoutKey, String numberToShow, int startIndex, ColumnLayout.ColumnConfig columnConfig, List<String> columnNames) {
        ExtendedPreferences preferences = this.preferencesManager.getExtendedPreferences(this.authContext.getUser());
        IssueTableServiceConfiguration configuration = new IssueTableServiceConfiguration();
        configuration.setEnableSorting(true);
        configuration.setLayoutKey(layoutKey);
        configuration.setPaging(true);
        configuration.setStart(startIndex);
        configuration.setColumnNames(columnNames);
        configuration.setColumnConfig(columnConfig);
        if (preferences.getBoolean("user.show.actions.in.navigator")) {
            configuration.setShowActions(true);
        }
        if (numberToShow != null) {
            configuration.setNumberToShow(Integer.valueOf(numberToShow));
        } else {
            configuration.setNumberToShow(this.getPageSize());
        }
        return configuration;
    }

    private IssueTableServiceConfiguration buildConfiguration(String layoutKey, String numberToShow, int startIndex, List<String> explicitColumns, String columnConfigName) {
        ColumnLayout.ColumnConfig columnConfig = ColumnLayout.ColumnConfig.byValueIgnoreCase((String)columnConfigName);
        IssueTableServiceConfiguration config = this.createConfig(layoutKey, numberToShow, startIndex, columnConfig, null);
        if (ColumnLayout.ColumnConfig.EXPLICIT == columnConfig) {
            config.setColumnNames(explicitColumns);
        }
        return config;
    }

    private boolean userCanSeeFilter(Long filterId) {
        if (filterId != null && !SystemFilter.isSystemFilter((Long)filterId)) {
            ApplicationUser user = this.authContext.getUser();
            JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(user);
            SearchRequest filter = this.searchRequestService.getFilter((JiraServiceContext)jiraServiceContext, filterId);
            return filter != null;
        }
        return true;
    }

    private Response buildPrivateFilterResponse() {
        String key = this.authContext.isLoggedInUser() ? "issue.nav.filters.filter.private" : "issue.nav.filters.filter.private.anonymous";
        return Responses.error(this.authContext.getI18nHelper().getText(key));
    }
}

