/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuenav.rest;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.components.issueviewer.service.SystemFilter;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutStorageException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestInfo;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.web.action.issue.IssueNavigatorToolsHelper;
import com.atlassian.jira.web.action.issue.IssueNavigatorViewsHelper;
import com.atlassian.jira.web.action.issue.IssueSearchLimits;
import com.atlassian.jira.web.action.issue.navigator.ToolOptionGroup;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import com.atlassian.query.Query;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Path(value="issueNav/operations")
public class IssueNavToolsResource {
    private final JiraAuthenticationContext authContext;
    private final SearchService searchService;
    private final SearchRequestService searchRequestService;
    private final PermissionManager permissionManager;
    private final ApplicationProperties applicationProperties;
    private final ColumnLayoutManager columnLayoutManager;
    private final PluginAccessor pluginAccessor;
    private final IssueSearchLimits issueSearchLimits;

    public IssueNavToolsResource(JiraAuthenticationContext authContext, SearchService searchService, SearchRequestService searchRequestService, PermissionManager permissionManager, ApplicationProperties applicationProperties, ColumnLayoutManager columnLayoutManager, PluginAccessor pluginAccessor, IssueSearchLimits issueSearchLimits) {
        this.authContext = authContext;
        this.searchService = searchService;
        this.searchRequestService = searchRequestService;
        this.permissionManager = permissionManager;
        this.applicationProperties = applicationProperties;
        this.columnLayoutManager = columnLayoutManager;
        this.pluginAccessor = pluginAccessor;
        this.issueSearchLimits = issueSearchLimits;
    }

    @POST
    @RequiresXsrfCheck
    @Produces(value={"application/json"})
    @Path(value="views")
    public Response views(@FormParam(value="filterId") Long filterId, @FormParam(value="jql") String jql, @FormParam(value="modified") boolean modified) {
        HashMap viewOptions = Maps.newHashMap();
        List<ToolOptionGroup> filterOptionGroup = this.getFilterViewOptions(filterId, jql, modified);
        viewOptions.put("filter", filterOptionGroup);
        return Response.ok((Object)viewOptions).cacheControl(CacheControl.never()).build();
    }

    @POST
    @RequiresXsrfCheck
    @Produces(value={"application/json"})
    @Path(value="tools")
    public Response tools(@FormParam(value="searchResultsTotal") int searchResultsTotal, @FormParam(value="searchResultsPages") int searchResultsPages, @FormParam(value="filterId") Long filterId, @FormParam(value="jql") String jql, @FormParam(value="useColumns") boolean useColumns, @FormParam(value="skipColumns") boolean skipColumns) {
        IssueNavigatorToolsHelper.SearchResultInfo searchResultInfo = new IssueNavigatorToolsHelper.SearchResultInfo(searchResultsTotal, searchResultsPages);
        IssueNavigatorToolsHelper.SearchRequestInfo searchRequestInfo = new IssueNavigatorToolsHelper.SearchRequestInfo(filterId, this.getQuery(jql), useColumns, skipColumns, this.getOwnerUserName(filterId));
        IssueNavigatorToolsHelper toolsHelper = new IssueNavigatorToolsHelper(this.authContext, this.permissionManager, this.applicationProperties, this.columnLayoutManager, searchRequestInfo, searchResultInfo);
        try {
            List optionGroups = toolsHelper.getToolOptions();
            return Response.ok((Object)optionGroups).cacheControl(CacheControl.never()).build();
        }
        catch (ColumnLayoutStorageException ex) {
            this.throwError(ErrorCollection.of((String[])new String[]{ex.getMessage()}));
            return null;
        }
    }

    private Query getQuery(String jql) {
        if (null == jql) {
            return null;
        }
        SearchService.ParseResult parseResult = this.searchService.parseQuery(this.authContext.getLoggedInUser(), jql);
        if (!parseResult.isValid()) {
            this.throwError(ErrorCollection.of((Collection)parseResult.getErrors().getErrorMessages()));
        }
        return parseResult.getQuery();
    }

    private String getOwnerUserName(Long filterId) {
        if (null != filterId && !SystemFilter.isSystemFilter((Long)filterId)) {
            JiraServiceContextImpl serviceCtx = new JiraServiceContextImpl(this.authContext.getLoggedInUser());
            SearchRequest searchRequest = this.searchRequestService.getFilter((JiraServiceContext)serviceCtx, filterId);
            if (serviceCtx.getErrorCollection().hasAnyErrors()) {
                this.throwError(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)serviceCtx.getErrorCollection()));
            }
            return searchRequest.getOwnerUserName();
        }
        return null;
    }

    private List<ToolOptionGroup> getFilterViewOptions(Long filterId, String jql, boolean modified) {
        Query query;
        if (null != jql) {
            SearchService.ParseResult parseResult = this.searchService.parseQuery(this.authContext.getLoggedInUser(), jql);
            if (!parseResult.isValid()) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.never()).build());
            }
            query = parseResult.getQuery();
        } else {
            query = null;
        }
        SearchRequestInfo searchRequestInfo = new SearchRequestInfo(query, filterId, modified);
        return new IssueNavigatorViewsHelper(this.authContext, this.pluginAccessor, this.issueSearchLimits, this.searchService, searchRequestInfo).getViewOptions(null);
    }

    private void throwError(ErrorCollection errors) {
        Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errors).cacheControl(CacheControl.never()).build();
        throw new WebApplicationException(response);
    }
}

