/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuenav.data;

import com.atlassian.jira.components.data.JacksonJsonableMarshaller;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.webresource.api.data.WebResourceDataProvider;

public class UserParmsDataProvider
implements WebResourceDataProvider {
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;

    public UserParmsDataProvider(PermissionManager permissionManager, JiraAuthenticationContext authenticationContext) {
        this.permissionManager = permissionManager;
        this.authenticationContext = authenticationContext;
    }

    public Jsonable get() {
        return JacksonJsonableMarshaller.INSTANCE.marshal((Object)this.getUserParms());
    }

    private UserParms getUserParms() {
        return new UserParms().setCreateSharedObjects(this.permissionManager.hasPermission(22, this.getLoggedInUser())).setCreateIssue(this.permissionManager.hasProjects(11, this.getLoggedInUser()));
    }

    private ApplicationUser getLoggedInUser() {
        return this.authenticationContext.getLoggedInUser();
    }

    public static class UserParms {
        public boolean createSharedObjects;
        public boolean createIssue;

        public UserParms setCreateSharedObjects(boolean createSharedObjects) {
            this.createSharedObjects = createSharedObjects;
            return this;
        }

        public UserParms setCreateIssue(boolean createIssue) {
            this.createIssue = createIssue;
            return this;
        }
    }
}

