/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuenav;

import com.atlassian.jira.plugin.webresource.JiraWebResourceManager;

class TraceKeys {
    private final JiraWebResourceManager jiraWebResourceManager;

    static void write(JiraWebResourceManager jiraWebResourceManager) {
        new TraceKeys(jiraWebResourceManager).write();
    }

    TraceKeys(JiraWebResourceManager jiraWebResourceManager) {
        this.jiraWebResourceManager = jiraWebResourceManager;
    }

    void write() {
        AjaxTraces keys = new AjaxTraces();
        this.jiraWebResourceManager.putMetadata("view-issue-trace-key", keys.viewIssue().name());
        this.jiraWebResourceManager.putMetadata("view-issue-psycho-key", keys.viewIssue().psychoName());
        if (keys.viewIssue().refreshedCachedName() != null) {
            this.jiraWebResourceManager.putMetadata("view-issue-refreshed-cached-key", keys.viewIssue().refreshedCachedName());
        }
        this.jiraWebResourceManager.putMetadata("return-to-search-trace-key", keys.returnToSearch().name());
        this.jiraWebResourceManager.putMetadata("return-to-search-psycho-key", keys.returnToSearch().psychoName());
    }

    private class AjaxTraces
    implements Traces {
        private AjaxTraces() {
        }

        @Override
        public Trace viewIssue() {
            return new Trace("jira.issue.refreshed", "jira.psycho.issue.refreshed", "jira.psycho.issue.refreshed.cached");
        }

        @Override
        public Trace returnToSearch() {
            return new Trace("jira.returned.to.search", "jira.psycho.returned.to.search", null);
        }
    }

    static interface Traces {
        public Trace viewIssue();

        public Trace returnToSearch();
    }

    final class Trace {
        private final String name;
        private final String psychoName;
        private final String refreshedCachedName;

        Trace(String name) {
            this(name, name, null);
        }

        Trace(String name, String psychoName, String refreshedCachedName) {
            this.name = name;
            this.psychoName = psychoName;
            this.refreshedCachedName = refreshedCachedName;
        }

        String name() {
            return this.name;
        }

        String psychoName() {
            return this.psychoName;
        }

        String refreshedCachedName() {
            return this.refreshedCachedName;
        }
    }
}

