/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuenav;

import com.atlassian.jira.components.issueviewer.service.SystemFilter;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.web.bean.PagerFilter;
import javax.ws.rs.core.UriBuilder;

public class Search {
    private final Long filter;
    private final String jql;
    private final int startIndex;

    public Search(SearchRequest searchRequest, JqlStringSupport jqlStringSupport, PagerFilter<?> pagerFilter) {
        if (null != searchRequest.getId()) {
            this.filter = searchRequest.getId();
            this.jql = searchRequest.isModified() ? jqlStringSupport.generateJqlString(searchRequest.getQuery()) : null;
        } else {
            this.filter = null;
            this.jql = jqlStringSupport.generateJqlString(searchRequest.getQuery());
        }
        this.startIndex = null == pagerFilter ? 0 : pagerFilter.getStart();
    }

    public Search(Long filter, String jql) {
        this.filter = filter;
        this.jql = jql;
        this.startIndex = 0;
    }

    public Search(SystemFilter filter) {
        this(filter.getId(), null);
    }

    public String toQueryString() {
        UriBuilder uriBuilder = UriBuilder.fromPath((String)"");
        if (null != this.filter) {
            uriBuilder.queryParam("filter", new Object[]{this.filter});
        }
        if (null != this.jql) {
            uriBuilder.queryParam("jql", new Object[]{this.urlEncode(this.jql)});
        }
        if (this.startIndex > 0) {
            uriBuilder.queryParam("startIndex", new Object[]{this.startIndex});
        }
        return uriBuilder.build(new Object[0]).toString().replace("+", "%20");
    }

    public Long getFilter() {
        return this.filter;
    }

    public String getJql() {
        return this.jql;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    private String urlEncode(String input) {
        String output = String.valueOf(input);
        output = output.replace(":", "%3A");
        return output;
    }
}

