/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuenav;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestFactory;
import com.atlassian.jira.issue.transport.ActionParams;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.google.common.base.Function;
import javax.annotation.Nullable;

class LegacyUrlToJql
implements Function<ActionParams, String> {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private SearchService searchService;
    private final SearchRequestFactory searchRequestFactory;

    LegacyUrlToJql(JiraAuthenticationContext jiraAuthenticationContext, SearchService searchService, SearchRequestFactory searchRequestFactory) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.searchService = searchService;
        this.searchRequestFactory = searchRequestFactory;
    }

    public String apply(@Nullable ActionParams actionParams) {
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
        SearchRequest searchRequest = this.searchRequestFactory.createFromParameters(null, loggedInUser, actionParams);
        Query query = searchRequest.getQuery();
        return this.searchService.getGeneratedJqlString(query);
    }
}

