/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuenav;

import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.jira.bc.admin.ApplicationPropertiesService;
import com.atlassian.jira.bc.filter.ProjectSearchRequestService;
import com.atlassian.jira.components.issueviewer.config.IssueNavFeatures;
import com.atlassian.jira.config.Feature;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.action.AjaxHeaders;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

@Scanned
public class IssueNavRewriteFilter
extends AbstractHttpFilter {
    static final String BASE_URL = "/secure/IssueNavAction!default.jspa";
    private static final int GROUP_ROOT = 1;
    private static final int GROUP_ISSUE_KEY = 2;
    private final ApplicationPropertiesService applicationPropertiesService;
    private final IssueManager issueManager;
    private final FeatureManager featureManager;
    private final ProjectSearchRequestService projectSearchRequestService;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public IssueNavRewriteFilter(ApplicationPropertiesService applicationPropertiesService, IssueManager issueManager, FeatureManager featureManager, @ComponentImport ProjectSearchRequestService projectSearchRequestService, JiraAuthenticationContext jiraAuthenticationContext) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.issueManager = issueManager;
        this.featureManager = featureManager;
        this.projectSearchRequestService = projectSearchRequestService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    private URLComponents getURLComponents(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        String projectKeyPattern = this.applicationPropertiesService.getApplicationProperty("jira.projectkey.pattern").getCurrentValue();
        String URL2 = request.getRequestURI();
        Pattern nonPushStatePattern = Pattern.compile(Pattern.quote(contextPath) + "/(i)");
        Pattern pushStatePattern = Pattern.compile(Pattern.quote(contextPath) + "/(browse|issues)/(" + projectKeyPattern + "-.*)?");
        Matcher matcher = nonPushStatePattern.matcher(URL2);
        if (matcher.matches()) {
            return new URLComponents(null, matcher.group(1));
        }
        matcher = pushStatePattern.matcher(URL2);
        if (matcher.matches()) {
            return new URLComponents(matcher.group(2), matcher.group(1));
        }
        Pattern issueKeyPattern = Pattern.compile(Pattern.quote(contextPath) + "/(browse)/([^/]+-[0-9]+)?");
        matcher = issueKeyPattern.matcher(URL2);
        if (matcher.matches() && this.issueManager.getIssueObject(matcher.group(2)) != null) {
            return new URLComponents(matcher.group(2), matcher.group(1));
        }
        return null;
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        URLComponents urlComponents = this.getURLComponents(request);
        if (urlComponents != null) {
            request.setAttribute("kickass-issue-nav-root", (Object)("/" + urlComponents.getRoot() + "/"));
            request.setAttribute("kickass-redirect-original-url", (Object)request.getRequestURI());
            String issueKey = urlComponents.getIssueKey();
            boolean renderViewIssue = StringUtils.isNotBlank((CharSequence)issueKey);
            if (renderViewIssue && this.shouldRedirectToPlugin(request, issueKey)) {
                String url = String.format("%s?issueKey=%s&serverRenderedViewIssue=true", BASE_URL, issueKey);
                request.getRequestDispatcher(url).forward((ServletRequest)request, (ServletResponse)response);
            } else if (!"browse".equals(urlComponents.getRoot())) {
                request.getRequestDispatcher(BASE_URL).forward((ServletRequest)request, (ServletResponse)response);
            } else {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private boolean shouldRedirectToPlugin(HttpServletRequest request, String issueKey) {
        boolean darkFeatureEnabled = !this.featureManager.isEnabled((Feature)IssueNavFeatures.REDIRECT_FROM_GLOBAL_TO_PROJECT_OFF);
        boolean isATabRequest = AjaxHeaders.isPjaxRequest((HttpServletRequest)request);
        return isATabRequest || !darkFeatureEnabled || this.hasSearchParameters(request) && !this.isProjectFilter(request, issueKey);
    }

    private boolean hasSearchParameters(HttpServletRequest request) {
        return Arrays.asList("filter", "jql").stream().map(arg_0 -> ((HttpServletRequest)request).getParameter(arg_0)).filter(param -> param != null).findAny().isPresent();
    }

    private boolean isProjectFilter(HttpServletRequest request, String issueKey) {
        Optional<String> filter = Optional.of("filter").map(arg_0 -> ((HttpServletRequest)request).getParameter(arg_0));
        if (!filter.isPresent()) {
            return false;
        }
        return filter.map(Longs::tryParse).map(filterId -> Optional.of(issueKey).filter(StringUtils::isNotBlank).map(arg_0 -> ((IssueManager)this.issueManager).getIssueObject(arg_0)).map(Issue::getProjectObject).map(project -> this.projectSearchRequestService.getSearchRequestsForProject(this.jiraAuthenticationContext.getLoggedInUser(), project).stream().mapToLong(SearchRequest::getId).filter(filterId::equals).findFirst().isPresent()).orElse(false)).orElse(true);
    }

    private static class URLComponents {
        private final String issueKey;
        private final String root;

        public URLComponents(String issueKey, String root) {
            this.issueKey = issueKey;
            this.root = root;
        }

        public String getIssueKey() {
            return this.issueKey;
        }

        public String getRoot() {
            return this.root;
        }
    }
}

