/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuenav;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.components.issueviewer.action.IssueBean;
import com.atlassian.jira.components.issueviewer.config.IssueNavFeatures;
import com.atlassian.jira.components.issueviewer.service.ActionUtilsService;
import com.atlassian.jira.components.issueviewer.service.SessionSearchService;
import com.atlassian.jira.components.issueviewer.service.SystemFilter;
import com.atlassian.jira.components.issueviewer.service.SystemFilterService;
import com.atlassian.jira.components.issueviewer.util.HashTransformer;
import com.atlassian.jira.components.issueviewer.viewissue.webpanel.IssueWebPanelsBean;
import com.atlassian.jira.components.issueviewer.viewissue.webpanel.WebPanelMapperUtil;
import com.atlassian.jira.components.query.SearchResults;
import com.atlassian.jira.components.query.SearcherService;
import com.atlassian.jira.components.query.util.UserSearchModeService;
import com.atlassian.jira.config.Feature;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.util.IssueWebPanelRenderUtil;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.plugin.issuenav.FilterDeletionWarningViewProviderAdapter;
import com.atlassian.jira.plugin.issuenav.Search;
import com.atlassian.jira.plugin.issuenav.TraceKeys;
import com.atlassian.jira.plugin.issuenav.service.issuetable.IssueTable;
import com.atlassian.jira.plugin.issuenav.service.issuetable.IssueTableService;
import com.atlassian.jira.plugin.issuenav.service.issuetable.IssueTableServiceConfiguration;
import com.atlassian.jira.plugin.issuenav.service.issuetable.IssueTableServiceOutcome;
import com.atlassian.jira.plugin.issuenav.util.DefaultSearchUtil;
import com.atlassian.jira.plugin.issuenav.util.PreferredSearchLayoutService;
import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcutManager;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.plugin.webresource.JiraWebResourceManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.issue.OpsbarBean;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.CachingUserHistoryStore;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.user.preferences.ExtendedPreferences;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.action.AjaxHeaders;
import com.atlassian.jira.web.action.IssueActionSupport;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.issue.IssueMetadataHelper;
import com.atlassian.jira.web.action.issue.IssueNavigatorSearchResultsHelper;
import com.atlassian.jira.web.action.issue.SearchResultsInfo;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.component.ModuleWebComponent;
import com.atlassian.jira.web.pagebuilder.Decorator;
import com.atlassian.jira.web.pagebuilder.GeneralJspDecorator;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import com.atlassian.jira.web.util.HelpUtil;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.plugins.rest.common.json.DefaultJaxbJsonMarshaller;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.OrderByImpl;
import com.atlassian.query.order.SearchSort;
import com.atlassian.seraph.util.RedirectUtils;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.webresource.api.assembler.RequiredData;
import com.atlassian.webresource.api.assembler.RequiredResources;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.ObjectMapper;
import webwork.action.Action;
import webwork.action.ServletActionContext;

public class IssueNavAction
extends IssueActionSupport
implements OperationContext {
    private static final String PROJECT_ID = "projectId";
    private static final String PROJECT_KEY = "projectKey";
    private static final String PROJECT_TYPE = "projectType";
    private boolean pageResourcesAlreadyRequired = false;
    private boolean pageResourcesAlreadyFlushed = false;
    static final String ISSUE = "issue";
    static final String TAB_CONTENT_ONLY = "tabContentOnly";
    static final String ISSUE_NAV_ROOT = "kickass-issue-nav-root";
    static final String ORIGINAL_URL = "kickass-redirect-original-url";
    static final String REDIRECT_FROM_I = "redirect-from-i";
    static final String REDIRECT_TO_I = "redirect-to-i";
    private final JiraWebResourceManager wrm;
    private final ApplicationProperties applicationProperties;
    private final KeyboardShortcutManager keyboardShortcutManager;
    private final IssueService issueService;
    private final JiraPageBuilderService jiraPageBuilderService;
    private String issueKey;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final IssueTableService issueTableService;
    private ServiceOutcome<IssueTableServiceOutcome> issueTableOutcome;
    private final JqlStringSupport jqlStringSupport;
    private final UserPreferencesManager preferencesManager;
    private final HashTransformer hashTransformer;
    private final SessionSearchService sessionSearchService;
    private final SimpleLinkManager simpleLinkManager;
    private final SearcherService searcherService;
    private final SearchRequestService searchRequestService;
    private final SystemFilterService systemFilterService;
    private HelpUtil helpUtil;
    private final DefaultSearchUtil defaultSearchUtil;
    private final FeatureManager featureManager;
    private final UserSearchModeService userSearchModeService;
    private final AvatarService avatarService;
    private final IssueNavigatorSearchResultsHelper searchResultsHelper;
    private final BeanBuilderFactory beanBuilderFactory;
    private final IssueMetadataHelper issueMetadataHelper;
    private final WebPanelMapperUtil webPanelMapperUtil;
    private final ChangeHistoryManager changeHistoryManager;
    private final ActionUtilsService actionUtilsService;
    private IssueWebPanelRenderUtil issueWebPanelRenderUtil;
    private final WebInterfaceManager webInterfaceManager;
    private final ModuleWebComponent moduleWebComponent;
    private final UserIssueHistoryManager userIssueHistoryManager;
    private final PreferredSearchLayoutService preferredSearchLayoutService;
    private final FilterDeletionWarningViewProviderAdapter filterDeletionWarningViewProviderAdapter;
    private Long filter;
    private String jql;
    private boolean jqlRequested = false;
    private Search search;
    private Integer startIndex;
    private String quickSearchQuery;
    private ServiceOutcome<SearchResults> searcherServiceOutcome;
    private boolean serverRenderedViewIssue;
    private final Map<String, Object> fieldValuesHolder = new HashMap<String, Object>();
    private Map<String, Object> viewIssueRenderData;
    private String hashURL;
    private boolean prefetch = false;
    private IssueService.IssueResult cachedRequestedIssue = null;

    public IssueNavAction(ApplicationProperties applicationProperties, KeyboardShortcutManager keyboardShortcutManager, IssueService issueService, IssueTableService issueTableService, VelocityRequestContextFactory velocityRequestContextFactory, JqlStringSupport jqlStringSupport, UserPreferencesManager preferencesManager, SessionSearchService sessionSearchService, SimpleLinkManager simpleLinkManager, DefaultSearchUtil defaultSearchUtil, FeatureManager featureManager, UserSearchModeService userSearchModeService, SearcherService searcherService, SearchRequestService searchRequestService, SystemFilterService systemFilterService, AvatarService avatarService, IssueNavigatorSearchResultsHelper searchResultsHelper, BeanBuilderFactory beanBuilderFactory, WebPanelMapperUtil webPanelMapperUtil, IssueMetadataHelper issueMetadataHelper, ChangeHistoryManager changeHistoryManager, ActionUtilsService actionUtilsService, WebInterfaceManager webInterfaceManager, ModuleWebComponent moduleWebComponent, UserIssueHistoryManager userIssueHistoryManager, PreferredSearchLayoutService preferredSearchLayoutService, JiraPageBuilderService jiraPageBuilderService, FilterDeletionWarningViewProviderAdapter filterDeletionWarningViewProviderAdapter) {
        this.issueService = issueService;
        this.issueTableService = issueTableService;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.jqlStringSupport = jqlStringSupport;
        this.preferencesManager = preferencesManager;
        this.sessionSearchService = sessionSearchService;
        this.simpleLinkManager = simpleLinkManager;
        this.featureManager = featureManager;
        this.searcherService = searcherService;
        this.searchRequestService = searchRequestService;
        this.systemFilterService = systemFilterService;
        this.webInterfaceManager = webInterfaceManager;
        this.moduleWebComponent = moduleWebComponent;
        this.filterDeletionWarningViewProviderAdapter = filterDeletionWarningViewProviderAdapter;
        this.hashTransformer = new HashTransformer();
        this.wrm = (JiraWebResourceManager)ComponentAccessor.getComponentOfType(WebResourceManager.class);
        this.applicationProperties = applicationProperties;
        this.keyboardShortcutManager = keyboardShortcutManager;
        this.defaultSearchUtil = defaultSearchUtil;
        this.userSearchModeService = userSearchModeService;
        this.avatarService = avatarService;
        this.searchResultsHelper = searchResultsHelper;
        this.beanBuilderFactory = beanBuilderFactory;
        this.webPanelMapperUtil = webPanelMapperUtil;
        this.issueMetadataHelper = issueMetadataHelper;
        this.changeHistoryManager = changeHistoryManager;
        this.actionUtilsService = actionUtilsService;
        this.userIssueHistoryManager = userIssueHistoryManager;
        this.preferredSearchLayoutService = preferredSearchLayoutService;
        this.jiraPageBuilderService = jiraPageBuilderService;
    }

    public String doDefault() throws Exception {
        String doNavReturn;
        this.viewIssueRenderData = new HashMap<String, Object>();
        String shouldRedirect = this.handleRedirectsForIssueNav();
        if (!shouldRedirect.isEmpty()) {
            return shouldRedirect;
        }
        this.requireKeyboardShortcuts();
        this.jiraPageBuilderService.assembler().data().requireData("com.atlassian.jira.jira-issue-nav-components:inline-edit-enabled", Boolean.valueOf(this.actionUtilsService.isInlineEditEnabled()));
        if (AjaxHeaders.isPjaxRequest((HttpServletRequest)this.request)) {
            return this.doTabContent();
        }
        if (!this.isServerRenderedIssue().booleanValue()) {
            this.setServerRenderedViewIssue(false);
            return this.doNav();
        }
        if (this.isInSearchContext().booleanValue() && !"success".equals(doNavReturn = this.doNav())) {
            return doNavReturn;
        }
        return this.doIssue();
    }

    private String handleRedirectsForIssueNav() throws Exception {
        if (this.request.getParameterMap().containsKey("redirectedFromClassic")) {
            return this.handleRedirectFromClassic();
        }
        IssueService.IssueResult result = this.getCachedRequestedIssue();
        if (result.isValid() && !result.getIssue().getKey().equals(this.getIssueKey())) {
            String issueNavRoot = (String)this.request.getAttribute(ISSUE_NAV_ROOT);
            String query = this.actionUtilsService.getQueryStringFromComponents(this.request.getParameterMap());
            String redirectUrl = issueNavRoot + result.getIssue().getKey() + query;
            return this.getRedirect(redirectUrl);
        }
        if (this.shouldRedirectToHashURL() && !AjaxHeaders.isPjaxRequest((HttpServletRequest)this.request)) {
            String redirectToInvalidResult;
            if (!(result.isValid() && result.getIssue() != null || ISSUE.equals(redirectToInvalidResult = this.handleInvalidIssue(result)))) {
                return redirectToInvalidResult;
            }
            this.hashURL = this.hashTransformer.transformURL(this.getCurrentUrlWithoutContextPath(), this.request.getParameterMap());
            return REDIRECT_TO_I;
        }
        if (this.shouldRedirectToFullURL() && !AjaxHeaders.isPjaxRequest((HttpServletRequest)this.request)) {
            return REDIRECT_FROM_I;
        }
        return "";
    }

    public Boolean isInSearchContext() {
        return this.filter != null || this.jql != null;
    }

    private String getCurrentUrlWithoutContextPath() {
        String currentURL = (String)this.request.getAttribute(ORIGINAL_URL);
        return currentURL.replaceFirst(this.request.getContextPath(), "");
    }

    public String getHashURL() {
        return this.request.getContextPath() + this.hashURL;
    }

    private void requirePageResources(boolean flush, IssueNavActionType action) {
        if (!this.pageResourcesAlreadyRequired) {
            this.pageResourcesAlreadyRequired = true;
            this.requireWebResources(action);
            this.requireMetadata();
        }
        if (!this.pageResourcesAlreadyFlushed && flush) {
            this.pageResourcesAlreadyFlushed = true;
            this.flushHeadIfEnabled();
        }
    }

    private String doNav() throws Exception {
        SearchRequest filterSearchRequest;
        if (this.shouldRedirectToLoginForSystemFilter(this.getFilter())) {
            return this.forceRedirect(RedirectUtils.getLoginUrl((HttpServletRequest)this.request));
        }
        if (this.isServerRenderedIssue().booleanValue() && (!this.getCachedRequestedIssue().isValid() || this.getCachedRequestedIssue().getIssue() == null)) {
            this.requirePageResources(false, IssueNavActionType.ISSUE_SEARCH);
        } else {
            this.requirePageResources(true, IssueNavActionType.ISSUE_SEARCH);
        }
        this.velocityRequestContextFactory.setVelocityRequestContext(this.request.getContextPath(), this.request);
        SystemFilter systemFilter = this.systemFilterService.getById(this.filter);
        try {
            filterSearchRequest = this.getFilterSearchRequest();
        }
        catch (IllegalArgumentException e) {
            this.searcherServiceOutcome = this.searcherService.searchWithJql((JiraWebActionSupport)this, "", null);
            this.sessionSearchService.setSessionSearch(null, null, 0, this.getPageSize());
            return "success";
        }
        if (this.jql != null) {
            this.performSearch(filterSearchRequest, this.jql);
        } else if (this.filter != null) {
            if (filterSearchRequest != null) {
                this.performSearch(filterSearchRequest, null);
            } else if (systemFilter != null) {
                this.performSearch(null, systemFilter.getJql());
            } else {
                this.issueTableOutcome = ServiceOutcomeImpl.error(null, null);
            }
        } else if (this.startIndex != null) {
            this.performSearch(null, "");
        } else {
            if (this.isHttpSessionDisabled()) {
                this.search = this.defaultSearchUtil.getSearch();
            } else {
                SearchRequest searchRequest = this.getSearchRequest();
                if (searchRequest != null) {
                    this.updateSessionSelectedIssueId(searchRequest);
                    this.search = new Search(searchRequest, this.jqlStringSupport, (PagerFilter)this.getSessionPagerFilterManager().getCurrentObject());
                } else {
                    this.search = this.defaultSearchUtil.getSearch();
                }
            }
            this.setFilter(this.search.getFilter());
            this.setCurrentJql(this.search.getJql());
        }
        return "success";
    }

    private boolean isHttpSessionDisabled() {
        return IssueNavFeatures.HTTP_SESSIONS_DISABLED.isEnabled(this.featureManager);
    }

    public String getClientRedirectResourcesHtml() {
        ArrayList resourceKeys = Lists.newArrayList((Object[])new String[]{"com.atlassian.jira.jira-issue-nav-plugin:hash-rewrite"});
        StringWriter stringWriter = new StringWriter();
        this.wrm.includeResources((Iterable)resourceKeys, (Writer)stringWriter, UrlMode.RELATIVE);
        return stringWriter.toString();
    }

    private void updateSessionSelectedIssueId(SearchRequest searchRequest) throws SearchException {
        SearchResultsInfo searchResultsInfo = this.searchResultsHelper.getSearchResults(searchRequest.getQuery(), false);
        this.searchResultsHelper.ensureAnIssueIsSelected(searchResultsInfo, false);
    }

    public String getCriteriaJson() {
        if (this.searcherServiceOutcome != null) {
            DefaultJaxbJsonMarshaller marshaller = new DefaultJaxbJsonMarshaller();
            if (this.searcherServiceOutcome.isValid()) {
                return marshaller.marshal(this.searcherServiceOutcome.getReturnedValue());
            }
            ErrorCollection errors = ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)this.searcherServiceOutcome.getErrorCollection());
            return marshaller.marshal((Object)errors);
        }
        return null;
    }

    public String getSystemFiltersJson() {
        return this.actionUtilsService.getSystemFiltersJson();
    }

    public String getSelectedIssueJson() {
        MutableIssue issue = this.getIssueManager().getIssueObject(this.issueKey);
        JSONObject json = new JSONObject();
        try {
            if (issue != null) {
                json.put("id", (Object)issue.getId());
                json.put("key", (Object)issue.getKey());
                return json.toString();
            }
            if (this.issueKey != null) {
                json.put("id", -1);
                json.put("key", (Object)this.issueKey);
                return json.toString();
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return "";
    }

    public Collection<SimpleLink> getIssueOperations() {
        ArrayList<SimpleLink> links = new ArrayList<SimpleLink>();
        Map params = MapBuilder.newBuilder().add((Object)"issueId", (Object)"{0}").toMap();
        JiraHelper helper = new JiraHelper(this.request, null, params);
        List sections = this.simpleLinkManager.getSectionsForLocation("opsbar-operations", this.getLoggedInUser(), helper);
        for (SimpleLinkSection section : sections) {
            links.addAll(this.simpleLinkManager.getLinksForSectionIgnoreConditions(section.getId(), this.getLoggedInUser(), helper));
        }
        return links;
    }

    public Boolean isProjectShortcutEnabled() {
        return this.featureManager.isEnabled("rotp.project.shortcuts");
    }

    public List<SimpleLink> getPluggableItems() {
        ApplicationUser loggedInUser = this.getLoggedInUser();
        JiraHelper jiraHelper = new JiraHelper(ServletActionContext.getRequest());
        return this.simpleLinkManager.getLinksForSection("jira.navigator.pluggable.items", loggedInUser, jiraHelper, true);
    }

    public String getRemoteUserAvatarUrl() {
        ApplicationUser user = this.getLoggedInUser();
        return user == null ? "" : this.avatarService.getAvatarAbsoluteURL(user, user.getName(), Avatar.Size.LARGE).toString();
    }

    private String handleRedirectFromClassic() throws SearchException {
        SearchRequest searchRequest = this.getSearchRequest();
        if (null == searchRequest) {
            return this.getRedirect("/issues/?jql=");
        }
        this.updateSessionSelectedIssueId(searchRequest);
        Search search = new Search(searchRequest, this.jqlStringSupport, (PagerFilter)this.getSessionPagerFilterManager().getCurrentObject());
        return this.getRedirect("/issues/" + search.toQueryString());
    }

    private IssueService.IssueResult getCachedRequestedIssue() {
        if (this.cachedRequestedIssue == null) {
            this.cachedRequestedIssue = this.getRequestedIssue();
        }
        return this.cachedRequestedIssue;
    }

    private IssueService.IssueResult getRequestedIssue() {
        return this.issueService.getIssue(this.getLoggedInUser(), this.getIssueKey());
    }

    /*
     * Enabled aggressive block sorting
     */
    private String handleInvalidIssue(IssueService.IssueResult result) throws Exception {
        this.viewIssueRenderData.put("errorViewIssue", true);
        ErrorCollection.Reason worstReason = ErrorCollection.Reason.getWorstReason((Collection)result.getErrorCollection().getReasons());
        if (worstReason == ErrorCollection.Reason.FORBIDDEN) {
            this.viewIssueRenderData.put("errorType", "NoPermission");
            return ISSUE;
        }
        if (worstReason == ErrorCollection.Reason.NOT_FOUND && this.issueKey != null) {
            MutableIssue issue = (MutableIssue)this.changeHistoryManager.findMovedIssue(this.issueKey);
            if (issue == null) {
                this.viewIssueRenderData.put("errorType", "DoesNotExist");
                return ISSUE;
            }
            String issueNavRoot = (String)this.request.getAttribute(ISSUE_NAV_ROOT);
            String query = this.actionUtilsService.getQueryStringFromComponents(this.request.getParameterMap());
            String redirectUrl = issueNavRoot + issue.getKey() + query;
            return this.getRedirect(redirectUrl);
        }
        if (worstReason == ErrorCollection.Reason.NOT_LOGGED_IN) {
            return "permissionviolation";
        }
        this.viewIssueRenderData.put("errorType", "Generic");
        return ISSUE;
    }

    public String doIssue() throws Exception {
        IssueService.IssueResult result = this.getCachedRequestedIssue();
        if (!result.isValid() || result.getIssue() == null) {
            String view = this.handleInvalidIssue(result);
            if (view.equals(ISSUE)) {
                this.requirePageResources(true, IssueNavActionType.ISSUE);
            }
            return view;
        }
        this.wrm.putMetadata("serverRenderedViewIssue", Boolean.toString(this.isServerRenderedViewIssue()));
        this.viewIssueRenderData.put("serverRenderedViewIssue", this.isServerRenderedViewIssue());
        this.requirePageResources(true, IssueNavActionType.ISSUE);
        MutableIssue issue = result.getIssue();
        Project projectObject = issue.getProjectObject();
        this.tagMauEventWithProject(projectObject);
        OpsbarBean opsbarBean = this.beanBuilderFactory.newOpsbarBeanBuilder((Issue)issue).build();
        Map metadata = this.issueMetadataHelper.getMetadata((Issue)issue, this.sessionSearchService.getSessionSearch());
        boolean isEditable = this.issueService.isEditable((Issue)issue, this.getLoggedInUser());
        IssueBean issueBean = new IssueBean((Issue)issue, metadata, opsbarBean, projectObject, issue.getStatusObject(), null, true, isEditable);
        IssueWebPanelsBean panels = this.webPanelMapperUtil.create((Issue)issue, (Action)this);
        if (!this.isPrefetch()) {
            this.userIssueHistoryManager.addIssueToHistory(this.getLoggedInUser(), (Issue)issue);
            this.setSelectedProjectId(projectObject.getId());
        }
        for (Map.Entry entry : metadata.entrySet()) {
            this.wrm.putMetadata((String)entry.getKey(), (String)entry.getValue());
        }
        this.wrm.putMetadata("server-view-issue-is-editable", Boolean.toString(isEditable));
        this.viewIssueRenderData.put("panels", panels);
        this.viewIssueRenderData.put(ISSUE, issueBean);
        this.viewIssueRenderData.put("pageTitle", "[" + issueBean.getKey() + "] " + issueBean.getSummary());
        this.viewIssueRenderData.put("hasProjectShortcut", this.isProjectShortcutEnabled());
        RequiredData wrmData = this.jiraPageBuilderService.assembler().data();
        wrmData.requireData(PROJECT_ID, (Number)projectObject.getId());
        wrmData.requireData(PROJECT_KEY, projectObject.getKey());
        ProjectTypeKey projectTypeKey = projectObject.getProjectTypeKey();
        wrmData.requireData(PROJECT_TYPE, projectTypeKey == null ? "" : projectTypeKey.getKey());
        return ISSUE;
    }

    private String doTabContent() {
        if (AjaxHeaders.requestUsernameMatches((HttpServletRequest)this.request, (ApplicationUser)this.getLoggedInUser())) {
            IssueService.IssueResult result = this.issueService.getIssue(this.getLoggedInUser(), this.getIssueKey());
            MutableIssue issue = result.getIssue();
            this.viewIssueRenderData.put(ISSUE, issue);
            this.viewIssueRenderData.put("pageTitle", "[" + issue.getKey() + "] " + issue.getSummary());
            return TAB_CONTENT_ONLY;
        }
        return "error";
    }

    public IssueWebPanelRenderUtil getRenderUtil() {
        Issue issue;
        if (this.issueWebPanelRenderUtil == null && (issue = (Issue)this.viewIssueRenderData.get(ISSUE)) != null) {
            this.issueWebPanelRenderUtil = new IssueWebPanelRenderUtil(this.getLoggedInUser(), issue, (Action)this, this.webInterfaceManager, this.moduleWebComponent);
        }
        return this.issueWebPanelRenderUtil;
    }

    public String renderActivityModule() {
        List webPanels = ((PluginAccessor)ComponentAccessor.getComponentOfType(PluginAccessor.class)).getEnabledModuleDescriptorsByClass(WebPanelModuleDescriptor.class);
        for (WebPanelModuleDescriptor webPanel : webPanels) {
            if (!"com.atlassian.jira.jira-view-issue-plugin:activitymodule".equals(webPanel.getCompleteKey())) continue;
            return ((WebPanel)webPanel.getModule()).getHtml(this.getRenderUtil().getWebPanelContext());
        }
        return "";
    }

    public Map<String, Object> getIssueSearchAndViewRenderData() {
        return this.viewIssueRenderData;
    }

    public boolean isServerRenderedViewIssue() {
        return this.serverRenderedViewIssue;
    }

    public void setServerRenderedViewIssue(boolean serverRenderedViewIssue) {
        this.serverRenderedViewIssue = serverRenderedViewIssue;
    }

    public boolean isEnableShortcutLinks() {
        return !this.actionUtilsService.noGlobalShortcutLinksIsEnabled();
    }

    private IssueTableServiceConfiguration getIssueTableConfig() {
        ExtendedPreferences preferences = this.preferencesManager.getExtendedPreferences(this.getLoggedInUser());
        IssueTableServiceConfiguration configuration = new IssueTableServiceConfiguration();
        configuration.setNumberToShow(this.getPageSize());
        configuration.setSelectedIssueKey(this.issueKey);
        if (preferences.getBoolean("user.show.actions.in.navigator")) {
            configuration.setShowActions(true);
        }
        if (this.startIndex != null && this.startIndex > 0) {
            configuration.setStart(this.startIndex);
        } else {
            configuration.setStart(0);
        }
        configuration.setColumnConfig(ColumnLayout.ColumnConfig.FILTER);
        return configuration;
    }

    private int getPageSize() {
        return (int)this.preferencesManager.getExtendedPreferences(this.getLoggedInUser()).getLong("user.issues.per.page");
    }

    public Object getIssueNavHtml() {
        if (this.issueTableOutcome != null && this.issueTableOutcome.isValid()) {
            if (this.isListLayout().booleanValue()) {
                return ((IssueTableServiceOutcome)this.issueTableOutcome.getReturnedValue()).getIssueTable().getTable();
            }
            if (this.isSplitLayout().booleanValue()) {
                try {
                    return this.renderSplitView();
                }
                catch (SoyException e) {
                    this.log.error((Object)("Exception thrown when rendering the split view soy template " + e.getMessage()));
                }
            }
        }
        return null;
    }

    private Boolean isListLayout() {
        return this.preferredSearchLayoutService.getPreferredSearchLayout().equals("list-view");
    }

    private Boolean isSplitLayout() {
        return this.preferredSearchLayoutService.getPreferredSearchLayout().equals("split-view");
    }

    private Boolean isServerRenderedIssue() {
        if (null == this.issueKey) {
            return false;
        }
        if (!this.isInSearchContext().booleanValue()) {
            return true;
        }
        if (this.isListLayout().booleanValue()) {
            return true;
        }
        return false;
    }

    public String getIssueNavJson() throws IOException {
        if (this.issueTableOutcome != null && this.issueTableOutcome.isValid()) {
            ObjectMapper mapper = new ObjectMapper().setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
            if (this.isListLayout().booleanValue()) {
                mapper.getSerializationConfig().addMixInAnnotations(IssueTable.class, RemoveTableMixIn.class);
            }
            return mapper.writeValueAsString(this.issueTableOutcome.getReturnedValue());
        }
        return null;
    }

    public String getSearch() throws IOException {
        if (null != this.search) {
            ObjectMapper mapper = new ObjectMapper().setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
            return mapper.writeValueAsString((Object)this.search);
        }
        return null;
    }

    public String getVisibleFieldNamesJson() throws JSONException {
        return this.actionUtilsService.getVisibleFieldNamesJson();
    }

    public String getVisibleFunctionNamesJson() throws JSONException {
        return this.actionUtilsService.getVisibleFunctionNamesJson();
    }

    public String getJqlReservedWordsJson() throws JSONException {
        return this.actionUtilsService.getJqlReservedWordsJson();
    }

    public String getIssueKey() {
        return this.issueKey;
    }

    public void setIssueKey(String issueKey) {
        this.issueKey = issueKey;
    }

    public String getUserSearchMode() {
        return this.userSearchModeService.getSearchMode();
    }

    public HelpUtil.HelpPath getAdvancedSearchHelpPath() {
        if (null == this.helpUtil) {
            this.helpUtil = new HelpUtil();
        }
        return this.helpUtil.getHelpPath("advanced_search");
    }

    public HelpUtil.HelpPath getIssueSearchHelpPath() {
        if (null == this.helpUtil) {
            this.helpUtil = new HelpUtil();
        }
        return this.helpUtil.getHelpPath("issue_search");
    }

    public String getJql() {
        return this.jql;
    }

    public void setJql(String jql) {
        this.jql = jql;
        this.jqlRequested = true;
    }

    private void setCurrentJql(String jql) {
        this.jql = jql;
        this.jqlRequested = false;
    }

    public boolean isJqlRequested() {
        return this.jqlRequested;
    }

    public Long getFilter() {
        return this.filter;
    }

    public void setFilter(Long filter) {
        this.filter = filter;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public String getQuickSearchQuery() {
        return this.quickSearchQuery;
    }

    public void setQuickSearchQuery(String quickSearchQuery) {
        this.quickSearchQuery = quickSearchQuery;
    }

    public boolean isPrefetch() {
        return this.prefetch;
    }

    public void setPrefetch(boolean prefetch) {
        this.prefetch = prefetch;
    }

    public Map getFieldValuesHolder() {
        return this.fieldValuesHolder;
    }

    public IssueOperation getIssueOperation() {
        return IssueOperations.EDIT_ISSUE_OPERATION;
    }

    private void flushHeadIfEnabled() {
        if (!this.featureManager.isEnabled("com.atlassian.plugins.issuenav.SEND_HEAD_EARLY.disabled")) {
            this.jiraPageBuilderService.get().setDecorator((Decorator)new GeneralJspDecorator(this.jiraPageBuilderService.assembler()));
            this.jiraPageBuilderService.get().flush();
        }
    }

    private void requireKeyboardShortcuts() {
        this.keyboardShortcutManager.requireShortcutsForContext(KeyboardShortcutManager.Context.issuenavigation);
        this.keyboardShortcutManager.requireShortcutsForContext(KeyboardShortcutManager.Context.issueaction);
    }

    private void requireMetadata() {
        this.wrm.putMetadata("hasCriteriaAutoUpdate", String.valueOf(this.applicationProperties.getOption("jira.issuenav.criteria.autoupdate")));
        this.wrm.putMetadata("viewissue-use-history-api", "false");
        this.wrm.putMetadata("viewissue-max-cache-size", this.applicationProperties.getString("jira.search.cache.max.size"));
        this.wrm.putMetadata("autocomplete-enabled", String.valueOf(!this.applicationProperties.getOption("jira.jql.autocomplete.disabled")));
        TraceKeys.write(this.wrm);
        URI avatarURL = this.avatarService.getAvatarURL(this.getLoggedInUser(), (ApplicationUser)null, Avatar.Size.SMALL);
        if (avatarURL != null) {
            String defaultAvatarUrl = avatarURL.toString();
            this.wrm.putMetadata("default-avatar-url", defaultAvatarUrl);
        }
        this.wrm.putMetadata("jira.issues.preferred.layout.key", this.preferredSearchLayoutService.getPreferredSearchLayout());
        this.wrm.putMetadata("max-recent-searchers", String.valueOf(CachingUserHistoryStore.getMaxItems((UserHistoryItem.Type)UserHistoryItem.ISSUESEARCHER, (ApplicationProperties)this.applicationProperties)));
        this.wrm.putMetadata("jira-base-url", this.applicationProperties.getString("jira.baseurl"));
    }

    private void requireWebResources(IssueNavActionType action) {
        RequiredResources requiredResources = this.jiraPageBuilderService.assembler().resources();
        if (action == IssueNavActionType.ISSUE) {
            requiredResources.requirePage("com.atlassian.jira.jira-issue-nav-plugin:issue-view-page");
        } else {
            requiredResources.requirePage("com.atlassian.jira.jira-issue-nav-plugin:issue-navigator-page");
            this.filterDeletionWarningViewProviderAdapter.requireDefaultStyle(requiredResources);
        }
    }

    private boolean shouldRedirectToHashURL() {
        String userAgent = this.request.getHeader("USER-AGENT");
        if (!this.hashTransformer.supportsPushState(userAgent) || this.featureManager.isEnabled((Feature)IssueNavFeatures.I_ROOT)) {
            Map parameters = this.request.getParameterMap();
            String originalURL = this.getCurrentUrlWithoutContextPath();
            if (this.request.getQueryString() != null) {
                originalURL = originalURL + "?" + this.request.getQueryString();
            }
            return !this.hashTransformer.transformURL(this.getCurrentUrlWithoutContextPath(), parameters).split("#")[0].equals(originalURL);
        }
        return false;
    }

    private boolean shouldRedirectToFullURL() {
        String userAgent = this.request.getHeader("USER-AGENT");
        return this.hashTransformer.supportsPushState(userAgent) && this.hashTransformer.isHashedUrl(this.getCurrentUrlWithoutContextPath()) && !this.featureManager.isEnabled((Feature)IssueNavFeatures.I_ROOT);
    }

    private boolean shouldRedirectToLoginForSystemFilter(Long filterId) {
        if (null != this.getLoggedInUser() || null == filterId) {
            return false;
        }
        SystemFilter systemFilter = this.systemFilterService.getById(filterId);
        return null != systemFilter && systemFilter.isRequiresLogin();
    }

    private SearchRequest getFilterSearchRequest() {
        if (this.filter != null && !SystemFilter.isSystemFilter((Long)this.filter)) {
            SearchRequest filterSearchRequest = this.searchRequestService.getFilter((JiraServiceContext)new JiraServiceContextImpl(this.getLoggedInUser()), this.filter);
            if (filterSearchRequest != null) {
                return filterSearchRequest;
            }
            throw new IllegalArgumentException("Filter ID is invalid or describes a private filter.");
        }
        return null;
    }

    private void performSearch(@Nullable SearchRequest filterSearchRequest, @Nullable String jql) {
        if (filterSearchRequest == null && jql == null) {
            throw new IllegalArgumentException("At least one of filterSearchRequest and jql must be provided.");
        }
        if (this.sessionSearchChanged(filterSearchRequest, jql)) {
            this.searchResultsHelper.resetPagerAndSelectedIssue();
        }
        String filterString = this.filter != null ? this.filter.toString() : "";
        IssueTableServiceConfiguration configuration = this.getIssueTableConfig();
        this.issueTableOutcome = this.issueTableService.getIssueTableFromFilterWithJql(filterString, jql, configuration, true);
        this.sessionSearchService.setSessionSearch(jql, this.filter, configuration.getStart(), configuration.getNumberToShow());
        if (jql == null) {
            jql = this.jqlStringSupport.generateJqlString(filterSearchRequest.getQuery());
        }
        this.searcherServiceOutcome = this.searcherService.searchWithJql((JiraWebActionSupport)this, jql, this.filter);
    }

    @VisibleForTesting
    boolean sessionSearchChanged(@Nullable SearchRequest filterSearchRequest, @Nullable String jql) {
        SearchRequest sessionSearchRequest = this.getSearchRequest();
        return sessionSearchRequest == null || !sessionSearchRequest.equals((Object)filterSearchRequest) && !this.jqlStringSupport.generateJqlString(sessionSearchRequest.getQuery()).equals(jql);
    }

    public final String doClearSorts() {
        SearchRequest sr = this.getSearchRequest();
        if (sr != null) {
            OrderByImpl orderByClause = new OrderByImpl(new SearchSort[0]);
            if (sr.getId() != null) {
                if (SystemFilter.isSystemFilter((Long)sr.getId())) {
                    SystemFilter systemFilter = SystemFilter.getSystemFilterById((Long)sr.getId());
                    orderByClause = systemFilter.getOrderBy();
                } else {
                    SearchRequest initialFilterRequest = this.searchRequestService.getFilter(this.getJiraServiceContext(), sr.getId());
                    if (initialFilterRequest != null && initialFilterRequest.getQuery() != null) {
                        orderByClause = initialFilterRequest.getQuery().getOrderByClause();
                    }
                }
            }
            sr.setQuery((Query)new QueryImpl(sr.getQuery().getWhereClause(), (OrderBy)orderByClause, sr.getQuery().getQueryString()));
            this.setSearchRequest(sr);
        }
        return this.forceRedirect("IssueNavigator.jspa");
    }

    public String renderSplitView() throws SoyException {
        IssueTable table = ((IssueTableServiceOutcome)this.issueTableOutcome.getReturnedValue()).getIssueTable();
        HashMap params = Maps.newHashMap();
        HashMap issuePanelData = Maps.newHashMap();
        Integer pageSize = this.getPageSize();
        Integer totalIssues = table.getEnd();
        Integer startIndex = table.getStartIndex();
        Integer endIndex = startIndex + pageSize > totalIssues ? totalIssues : startIndex + pageSize;
        issuePanelData.put("issues", table.getTable());
        issuePanelData.put("issueIDs", table.getIssueIds().subList(startIndex, endIndex));
        HashMap pagination = Maps.newHashMap();
        pagination.put("startIndex", startIndex);
        pagination.put("pageSize", pageSize);
        pagination.put("displayableTotal", totalIssues);
        String query = this.actionUtilsService.getQueryStringFromComponents(this.request.getParameterMap(), (List)Lists.newArrayList((Object[])new String[]{"jql", "filter"}));
        pagination.put("searchQuery", "issues/" + query);
        params.put("issuePanelData", issuePanelData);
        params.put("pagination", pagination);
        return this.actionUtilsService.getSoyRenderer().render("com.atlassian.jira.jira-issue-nav-plugin:issuenav-common", "JIRA.Templates.SplitView.fullSplitView", (Map)params);
    }

    private static abstract class RemoveTableMixIn {
        @JsonIgnore
        private String table;

        private RemoveTableMixIn() {
        }

        @JsonIgnore
        public abstract String getTable();
    }

    private static enum IssueNavActionType {
        ISSUE,
        ISSUE_SEARCH;

    }
}

