(function($) {
    "use strict";

    var catchExceptions = function(fn) {
        return function() {
            try {
                fn.apply(this, arguments);
            } catch (e) {
            }
            return this;
        };
    };

    $.fn.htmlCatchExceptions = catchExceptions($.fn.html);
    $.fn.appendCatchExceptions = catchExceptions($.fn.append);
    $.fn.prependCatchExceptions = catchExceptions($.fn.prepend);

    $.catchExceptions = function(html) {
        // Done this way because $(html) doesn't evaluate scripts until elements are added to the document
        return $('<div>').htmlCatchExceptions(html).children();
    };
})(AJS.$);
