AJS.test.require("com.atlassian.jira.jira-issue-nav-components:inlineeditparams-test", function() {
    "use strict";

    var INLINE_EDIT_DATA_KEY = 'com.atlassian.jira.jira-issue-nav-components:inline-edit-enabled';

    var WRMData = require('wrm/data');

    module("jira/components/util/inlineeditparams", {
        setup: function() {
            this.sandbox = sinon.sandbox.create();
            this.sandbox.stub(WRMData, 'claim');
        },
        teardown: function() {
            this.sandbox.restore();
        },
        enableInlineEdit: function() {
            return this._setInlineEditValue(true);
        },
        disableInlineEdit: function() {
            return this._setInlineEditValue(false);
        },
        undefinedInlineEdit: function() {
            return this._setInlineEditValue(undefined);
        },
        _setInlineEditValue: function(enabled) {
            var context = AJS.test.mockableModuleContext();
            WRMData.claim
                .withArgs(INLINE_EDIT_DATA_KEY)
                .returns(enabled);
            return context.require('jira/components/util/inlineeditparams');
        }
    });

    test("returns false when Inline Edit is disabled", function() {
        var InlineEditParams = this.disableInlineEdit();

        var enabled = InlineEditParams.isEnabled();

        equal(enabled, false);
    });

    test("reutrns true when Inline Edit is enabled", function() {
        var InlineEditParams = this.enableInlineEdit();

        var enabled = InlineEditParams.isEnabled();

        equal(enabled, true);
    });

    test("returns true when no value is specified", function() {
        var InlineEditParams = this.undefinedInlineEdit();

        var enabled = InlineEditParams.isEnabled();

        equal(enabled, true);
    });
});
