define("jira/issues/components/testutils", ["require"], function (require) {
    "use strict";

    var jQuery = require("jquery");
    var _ = require("jira/components/libs/underscore");
    var JIRAIssuesSearcherCollection = require("jira/components/query/basic/searchercollection");
    var JIRAIssuesQueryModule = require("jira/components/query/querymodule");
    var JIRAIssuesQueryStateModel = require("jira/components/query/querystatemodel");
    var DarkFeatures = require('jira/ajs/dark-features');
    var Messages = require("jira/components/query/messages");

    var AJSDarkFeatures = DarkFeatures;
    var sinonstub = sinon.stub;

    // QUnit 1.10.0 treats global JS errors as fail
    Messages.displayFailSearchMessage = jQuery.noop;

    return {

        /**
         * Create a mock of a given class.
         *
         * @param {function} constructor The class's constructor.
         * @return {object} a mock of the given class.
         * @private
         */
        _mockOfClass: function (constructor) {
            var mock = {};
            _.each(_.functions(constructor.prototype), function (functionName) {
                mock[functionName] = sinonstub();
            });

            return mock;
        },

        mockQueryModule: function () {
            return this._mockOfClass(JIRAIssuesQueryModule);
        },

        mockQueryStateModel: function () {
            return new JIRAIssuesQueryStateModel();
        },

        createSearcherCollection: function (vals) {
            var searcherCollection = new JIRAIssuesSearcherCollection(vals || [], {queryStateModel: this.mockQueryStateModel()});
            sinonstub(searcherCollection, "_querySearchersAndValues", function () {
                return new jQuery.Deferred().resolve().promise();
            });
            sinonstub(searcherCollection, "_querySearchersByValue", function () {
                return new jQuery.Deferred().resolve().promise();
            });
            return searcherCollection;
        },

        // Runs the block function with the dark feature temporarily switched on/off depending on toggle.
        // Use this for testing dark features since AJS.DarkFeature is global and thus not restored between tests.
        // Context is optional and sets the block's context (instead of requiring a _.bind()).
        darkFeature: function (darkFeatureKey, toggle, block, context) {
            var darkFeatures = {};
            darkFeatures[darkFeatureKey] = toggle;

            this.darkFeatures(darkFeatures, block, context);
        },

        /**
         * Execute a function within a dark feature configuration.
         *
         * @param {object} darkFeatures The dark features to enable/disable.
         * @param {function} block The function to execute within that dark feature configuration.
         * @param {object} context The context to invoke the function in.
         */
        darkFeatures: function (darkFeatures, block, context) {
            function setDarkFeatures(darkFeatures) {
                _.each(darkFeatures, function(value, key) {
                    AJSDarkFeatures[value ? "enable" : "disable"](key);
                });
            }

            var originalValues = {};
            _.each(darkFeatures, function (value, key) {
                originalValues[key] = AJSDarkFeatures.isEnabled(key);
            });

            setDarkFeatures(darkFeatures);
            block.call(context);
            setDarkFeatures(originalValues);
        },

        moveDialogToQunitFixture: function (dialog) {
            // Clean up the DOM
            dialog.dialog.$popup.appendTo(jQuery("#qunit-fixture"));
            dialog.dialog.$popup.css("position", "relative");
            jQuery(".aui-blanket").remove();
            jQuery(".jira-page-loading-indicator").remove();
            jQuery("body").css("overflow", "inherit");
        }
    };
});
