define("jira/components/simpleissuelist/views/pagination", ['require'], function (require) {
    "use strict";

    var Marionette = require('jira/components/libs/marionette-2.1.0');
    var URI = require('jira/components/libs/uri');
    var Templates = require('jira/components/simpleissuelist/templates');

    return Marionette.ItemView.extend({
        template: Templates.pagination,

        ui: {
            prev: ".icon-previous",
            next: ".icon-next",
            page: "a[data-page]"
        },

        triggers: {
            "click @ui.prev": "prev",
            "click @ui.next": "next"
        },

        onRender: function() {
            this.unwrapTemplate();
        },

        events: {
            "click @ui.page": function(e) {
                var val = e.target.getAttribute("data-page");
                e.preventDefault();
                this.trigger("goto", parseInt(val, 10) - 1);
            }
        },

        update: function(collection) {
            this.collection = collection;
            this.render();
        },

        serializeData: function() {
            if (!this.collection) return; //Because on the very first render, we don't have the collection yet.

            var url = new URI(this.options.baseURL);
            var hasQueryString = url.query().length > 0;

            return {
                startIndex: this.collection.state.pageSize * this.collection.state.currentPage,
                pageSize: this.collection.state.pageSize,
                searchQuery: url.toString(),
                hasQueryString: hasQueryString,
                displayableTotal: this.collection.state.totalRecords
            };
        }
    });
});
