AJS.test.require("com.atlassian.jira.jira-issue-nav-components:simpleissuelist-test", function() {
    "use strict";

    require([
        "jira/components/search/result",
        "jira/components/simpleissuelist/views/issue"
    ], function(
        Result,
        Issue
    ) {
        module("jira/components/simpleissuelist/views/issue", {
            setup: function() {
                this.model = new Result({
                    id: 1,
                    key: 'KEY-1',
                    summary: 'The first issue in the project',
                    type: {
                        name: 'bug',
                        description: 'A bug in your application',
                        icon: 'iconUrl.png'
                    }
                });

                this.view = new Issue({
                    model: this.model
                });
                this.view.render();
            }
        });

        test("When clicking on the issue, it throws the event 'select'", function() {
            var selectSpy = this.spy();
            this.view.on('select', selectSpy);

            this.view.ui.link.click();

            sinon.assert.calledOnce(selectSpy);
        });

        test("It highlights the issue", function() {
            this.view.highlight();

            ok(this.view.$el.hasClass("focused"));
        });

        test("It unhighlights the issue", function() {
            this.view.highlight();
            this.view.unhighlight();

            ok(!this.view.$el.hasClass("focused"));
        });

        test("It scrolls the issue into the view", function() {
            var scrollStub = this.stub(this.view.$el, "scrollIntoViewForAuto");

            this.view.scrollIntoView();

            sinon.assert.calledOnce(scrollStub);
        });

        test("When highlighting the issue, it scrolls the issue into the view", function() {
            var scrollStub = this.stub(this.view.$el, "scrollIntoViewForAuto");

            this.view.highlight();

            sinon.assert.calledOnce(scrollStub);
        });

        test("Focusing the view puts the focus in the link", function() {
            var onFocus = this.spy();
            this.view.ui.link.on('focus', onFocus);

            this.view.focus();

            sinon.assert.calledOnce(onFocus);
        });
    });
});
