AJS.test.require("com.atlassian.jira.jira-issue-nav-components:simpleissuelist-test", function() {
    "use strict";

    require([
        "jira/components/search/results",
        "jira/components/simpleissuelist"
    ], function(
        Results,
        SimpleIssueList
    ) {
        module("jira/components/simpleissuelist/services/api", {
            setup: function() {
                this.collection = new Results([
                    {id: 1, key: 'KEY-1', type: {}},
                    {id: 2, key: 'KEY-2', type: {}},
                    {id: 3, key: 'KEY-3', type: {}}
                ]);

                // This method exposes the API in the global namespace JIRA.API.Issues
                this.simpleIssueList = new SimpleIssueList();

                // This is a quick way to mock simpleIssueList.load(), the main entry point.
                this.simpleIssueList.searchResults = this.collection;
            }
        });

        test("Method 'nextIssue' selects the next issue in the collection", function() {
            this.collection.selected = this.collection.get(2);

            JIRA.API.Issues.nextIssue();

            equal(this.collection.selected, this.collection.get(3));
        });

        test("Method 'previousIssue' selects the previous issue in the collection", function() {
            this.collection.selected = this.collection.get(2);

            JIRA.API.Issues.previousIssue();

            equal(this.collection.selected, this.collection.get(1));
        });
    });
});
