AJS.test.require("com.atlassian.jira.jira-issue-nav-components:simpleissuelist-test",function(){require(["jira/components/test-utils/fakeserver","jira/components/test-utils/marionettemocker","jira/components/test-utils/mockutils","jira/components/search","jira/components/simpleissuelist/controllers/list","jira/components/simpleissuelist/services/api","jira/components/simpleissuelist/services/inline-issue-create","jquery"],function(g,a,f,d,h,c,b,i){var e=[{id:1,key:"DEMO-1",summary:"The first issue in the project",status:"Open",type:{name:"bug",description:"A bug in your application",icon:"iconUrl.png"}},{id:2,key:"DEMO-2",summary:"The second issue in the project",status:"Open",type:{name:"bug",description:"A bug in your application",icon:"iconUrl.png"}},{id:3,key:"DEMO-3",summary:"The third issue in the project",status:"Open",type:{name:"bug",description:"A bug in your application",icon:"iconUrl.png"}}];module("jira/components/simpleissuelist",{setup:function(){this.listController=a.createEventedMock(sinon,h);this.inlineIssueCreate=a.createEventedMock(sinon,b);this.SimpleIssueListConstructor=f.requireWithMocks("jira/components/simpleissuelist",{"jira/components/simpleissuelist/controllers/list":this.listController.constructor,"jira/components/simpleissuelist/services/inline-issue-create":this.inlineIssueCreate.constructor});this.simpleIssueList=new this.SimpleIssueListConstructor();this.simpleIssueList.show(i(JIRA.Components.SimpleIssueList.Templates.layout()));this.server=g.create(sinon,e);this.search=new d()},searchAndGetResults:function(j){var k;this.search.search().done(function(l){k=l});this.server.respond();this.simpleIssueList.load(k,j);this.server.respond();return k},searchAndGetEmptyResults:function(){var j;this.search.search().done(function(k){j=k});this.server.requests[0].respond(200,{"Content-Type":"application/json"},JSON.stringify({issueTable:{}}));this.simpleIssueList.load(j);return j}});test("When loading a search, it shows the results in the list",function(){var j=this.searchAndGetResults();sinon.assert.calledOnce(this.listController.update);sinon.assert.calledWith(this.listController.update,j)});test("When loading a search, it there is no results, it does not show the list view",function(){this.searchAndGetEmptyResults();sinon.assert.notCalled(this.listController.update)});test("When loading a search, it loads the first page and selects the first issue",function(){var j=this.searchAndGetResults("DEMO-1");equal(j.state.currentPage,0);equal(j.selected.get("key"),"DEMO-1")});test("When loading a new search, it stop listening events from the old search",function(){var j=this.searchAndGetResults();this.searchAndGetResults();j.get(2).set("summary","New Summary");sinon.assert.notCalled(this.listController.updateIssue)});test("When loading a search for a particular key, it loads the page for that key and selects it",function(){var j=this.searchAndGetResults("DEMO-3");equal(j.state.currentPage,1);equal(j.selected.get("key"),"DEMO-3")});test("When an issue is selected in the collection, it is marked as selected in the list",function(){var j=this.searchAndGetResults();this.listController.selectIssue.reset();j.select("DEMO-2");sinon.assert.calledOnce(this.listController.selectIssue);sinon.assert.calledWith(this.listController.selectIssue,2)});test("When an issue is selected in the collection, it triggers the 'select' event",function(){var k=this.searchAndGetResults();var j=this.spy();this.simpleIssueList.on("select",j);k.select("DEMO-2");sinon.assert.calledOnce(j);sinon.assert.calledWith(j,{id:2,key:"DEMO-2"})});test("When an issue is unselected in the collection, it is marked as unselected in the list",function(){var j=this.searchAndGetResults();j.unselect();sinon.assert.calledOnce(this.listController.unselectIssue);sinon.assert.calledWith(this.listController.unselectIssue,1)});test("When an issue is changed in the collection, it updates the issue in the list",function(){var j=this.searchAndGetResults();j.get(2).set("summary","New Summary");sinon.assert.calledOnce(this.listController.updateIssue);sinon.assert.calledWith(this.listController.updateIssue,j.get(2))});test("When the list wants to go to the previous page, the collection jumps to the previous page",function(){var j=this.searchAndGetResults("DEMO-3");this.spy(j,"jumpToPage");this.listController.trigger("goToPreviousPage");sinon.assert.calledOnce(j.jumpToPage);sinon.assert.calledWith(j.jumpToPage,"prev")});test("When the list wants to go to the next page, the collection jumps to the next page",function(){var j=this.searchAndGetResults();this.spy(j,"jumpToPage");this.listController.trigger("goToNextPage");sinon.assert.calledOnce(j.jumpToPage);sinon.assert.calledWith(j.jumpToPage,"next")});test("When the list wants to go to an arbitrary page, the collection jumps to that page",function(){var j=this.searchAndGetResults();this.spy(j,"jumpToPage");this.listController.trigger("goToPage",1);sinon.assert.calledOnce(j.jumpToPage);sinon.assert.calledWith(j.jumpToPage,1)});test("When the list wants to go to refresh the search, the component triggers the 'refresh' event too",function(){var j=this.spy();this.simpleIssueList.on("refresh",j);this.listController.trigger("refresh");sinon.assert.calledOnce(j)});test("When the list wants to select an issue, the collection selects that issue",function(){var j=this.searchAndGetResults();this.spy(j,"select");this.listController.trigger("selectIssue",{id:2,key:"DEMO-2"});sinon.assert.calledOnce(j.select);sinon.assert.calledWith(j.select,2)});test("When the list wants to select an issue, it triggers the 'list:select' event with the issue information",function(){this.searchAndGetResults();var j=this.spy();this.simpleIssueList.on("list:select",j);this.listController.trigger("selectIssue",{id:2,key:"DEMO-2"});sinon.assert.calledOnce(j);sinon.assert.calledWith(j,{id:2,key:"DEMO-2",relativePosition:1,absolutePosition:1})});test("When the list wants to sort the results, the component triggers the 'sort' event with the JQL",function(){var j=this.spy();this.simpleIssueList.on("sort",j);this.listController.trigger("sort","project=DEMO order by issuekey DESC");sinon.assert.calledOnce(j);sinon.assert.calledWith(j,"project=DEMO order by issuekey DESC")});test("When the list is updated, the component triggers the update event",function(){var j=this.spy();this.simpleIssueList.on("update",j);this.listController.trigger("update");sinon.assert.calledOnce(j)});test("When the component is created, it initializes the API",function(){this.spy(c,"init");var j=require("jira/components/simpleissuelist");this.simpleIssueList=new j();sinon.assert.calledOnce(c.init)});test("When disabling an issue, it sets the propper attribute in the model",function(){var j=this.searchAndGetResults();this.simpleIssueList.disableIssue(1);equal(j.get(1).get("inaccessible"),true)});test("When the 'before:loadpage' event is triggered, it retriggers it",function(){var j=this.searchAndGetResults();this.spy(this.simpleIssueList,"trigger");j.trigger("before:loadpage");sinon.assert.calledOnce(this.simpleIssueList.trigger);sinon.assert.calledWith(this.simpleIssueList.trigger,"before:loadpage")});test("When the 'error:loadpage' event is triggered, it retriggers it with the given payload",function(){var k={data:"some text"};var j=this.searchAndGetResults();this.spy(this.simpleIssueList,"trigger");j.trigger("error:loadpage",k);sinon.assert.calledOnce(this.simpleIssueList.trigger);sinon.assert.calledWith(this.simpleIssueList.trigger,"error:loadpage",k)});test("When the 'displayInlineIssueCreate' option is passed when instantiating the class, it creates an InlineIssueCreate view",function(){new this.SimpleIssueListConstructor({displayInlineIssueCreate:true});sinon.assert.calledOnce(this.inlineIssueCreate.constructor)});test("When the InlineIssueCreate triggers the event 'issueCreated', it is re-triggered",function(){var l=new this.SimpleIssueListConstructor({displayInlineIssueCreate:true});var j=this.spy();l.on("issueCreated",j);var k={};this.inlineIssueCreate.trigger("issueCreated",k);sinon.assert.calledOnce(j)});test("When the InlineIssueCreate triggers the event 'activated' event, we adjust the size of the list (deferred)",function(){var j=this.sandbox.useFakeTimers();new this.SimpleIssueListConstructor({displayInlineIssueCreate:true});this.inlineIssueCreate.trigger("activated");sinon.assert.notCalled(this.listController.adjustSize);j.tick(100);sinon.assert.calledOnce(this.listController.adjustSize)});test("When the InlineIssueCreate triggers the event 'deactivated' event, we adjust the size of the list (deferred)",function(){var j=this.sandbox.useFakeTimers();new this.SimpleIssueListConstructor({displayInlineIssueCreate:true});this.inlineIssueCreate.trigger("deactivated");sinon.assert.notCalled(this.listController.adjustSize);j.tick(100);sinon.assert.calledOnce(this.listController.adjustSize)});test("When we load a new set of results, it sets the JQL in the InlineIssueCreate component if present",function(){var k=new this.SimpleIssueListConstructor({displayInlineIssueCreate:true});var j;this.search.search().done(function(l){j=l});this.server.respond();j.jql="project='TEST'";k.load(j);sinon.assert.calledOnce(this.inlineIssueCreate.setJQL);sinon.assert.calledWith(this.inlineIssueCreate.setJQL,"project='TEST'")});test("When we show a SimpleIssueList with InlineIssueCreate component, it passes the component to the list",function(){this.listController.constructor.reset();new this.SimpleIssueListConstructor({displayInlineIssueCreate:true});sinon.assert.calledOnce(this.listController.constructor);ok(this.listController.constructor.lastCall.args[0].inlineIssueCreate===this.inlineIssueCreate)});test("Focusing the list delegates into the List controller",function(){this.simpleIssueList.focus();sinon.assert.calledOnce(this.listController.focus)})})});