AJS.test.require("com.atlassian.jira.jira-issue-nav-components:search-test",function(){require(["jira/components/test-utils/fakeserver","jira/components/libs/underscore","jira/components/search"],function(a,d,c){var b=[{id:1,key:"DEMO-1"},{id:2,key:"DEMO-2"},{id:3,key:"DEMO-3"}];module("jira/components/search",{setup:function(){this.search=new c();this.server=a.create(sinon,b)},serverAlwaysReturnsError:function(){this.server.restore();this.server.respondWith([400,{},""])}});test("When searching, it does a request to the correct URL using POST",function(){this.search.search("project=DEMO");var e=d.last(this.server.requests);equal(e.url,AJS.contextPath()+"/rest/issueNav/1/issueTable");equal(e.method,"POST")});test("When searching, it asks the server to skip token validation",function(){this.search.search("project=DEMO");equal(d.last(this.server.requests).requestHeaders["X-Atlassian-Token"],"no-check")});test("When searching, it sends the JQL to the server",function(){this.search.search("project=DEMO");var e=d.last(this.server.requests);var f=encodeURIComponent("project=DEMO");ok(e.requestBody.indexOf("jql="+f)>-1,"JQL is in the request")});test("When searching, it sends startIndex to the server",function(){this.search.search("project=DEMO");var e=d.last(this.server.requests);ok(e.requestBody.indexOf("id"===-1),"Request Body does not contain the ID of any issue");ok(e.requestBody.indexOf("startIndex">-1),"Request Body contains the start index")});test("When searching, it uses the issues as models",function(){this.search.search("project=DEMO");this.server.respond();equal(this.search.length,3);deepEqual(this.search.get(1).toJSON(),b[0]);deepEqual(this.search.get(2).toJSON(),b[1]);deepEqual(this.search.get(3).toJSON(),b[2])});test("When searching, it uses the provided preloaded data and does not call fetch",function(){this.search.setPreloadedData({jql:"project=DEMO",response:a.createIssueSearchResponse(b)});var e=this.sandbox.spy(this.search,"fetch");this.search.search("project=DEMO");sinon.assert.callCount(e,0)});test("When searching again, it does not use the preloaded data twice",function(){this.search.setPreloadedData({jql:"project=DEMO",response:a.createIssueSearchResponse(b)});var e=this.sandbox.spy(this.search,"fetch");this.search.search("project=DEMO");sinon.assert.callCount(e,0);this.search.search("project=DEMO");sinon.assert.callCount(e,1)});asyncTest("When it encounters an error during search, it rejects the promise",function(){this.serverAlwaysReturnsError();this.search.search("project=DEMO").fail(function(){ok(true)}).always(function(){start()});this.server.respond()})})});