define("jira/components/search/latestStorage", ['require'], function (require) {
    "use strict";

    var jQuery = require('jquery');
    var LocalStorage = require('jira/data/local-storage');

    var LATEST_SEARCH_KEY = "jira.issue.navigator.latest.search";

    return {
        get: function () {
            try {
                var storedLatestSearch = LocalStorage.getItem(LATEST_SEARCH_KEY);

                if (storedLatestSearch) {
                    var latestSearch = jQuery.parseJSON(storedLatestSearch);
                    if (latestSearch.jql || latestSearch.filter) {
                        return latestSearch;
                    }
                }
            } catch (e) {
                return {};
            }
        },

        /**
         * @param search.jql
         * @param search.filter
         */
        save: function (search) {
            try {
                LocalStorage.setItem(LATEST_SEARCH_KEY, JSON.stringify(search));
            } catch (ignored) {
            }

        }
    };
});
AJS.namespace("JIRA.Issues.LatestSearch", null, require("jira/components/search/latestStorage"));
