AJS.test.require(["com.atlassian.jira.jira-issue-nav-components:latest-search-store-test"], function() {
    "use strict";

    require([
        "jira/components/search/latestStorage"
    ], function() {
        var AJSTest = AJS.test;
        var moduleMocks;

        module("jira/components/search/latestStorage", {
            setup: function() {
                this.sandbox = sinon.sandbox.create();
                moduleMocks = AJSTest.mockableModuleContext();
            },

            teardown: function() {
                this.sandbox.restore();
            }
        });

        test("get retrieves correctly", function(){
            var localStore = {};
            moduleMocks.mock("jira/data/local-storage", localStore);
            localStore.getItem = sinon.spy();

            var LocalStorage = moduleMocks.require("jira/data/local-storage");

            var LatestSearchStore = moduleMocks.require("jira/components/search/latestStorage");
            LatestSearchStore.get();

            ok(LocalStorage.getItem.calledWith("jira.issue.navigator.latest.search"), "should delegate to get");
        });

        test("get exceptions are caught properly", function() {
            var localStore = {};
            moduleMocks.mock("jira/data/local-storage", localStore);
            localStore.getItem = sinon.stub()["throws"]();

            var LatestSearchStore = moduleMocks.require("jira/components/search/latestStorage");
            var result = LatestSearchStore.get();

            ok(localStore.getItem.threw());
            equal(Object.keys(result).length, 0, "exception should be caught properly");
        });

        test("save is delegated properly", function() {
            var localStore = {};
            moduleMocks.mock("jira/data/local-storage", localStore);
            localStore.setItem = sinon.spy();
            var search = {hello: "blah"};

            var LocalStorage = moduleMocks.require("jira/data/local-storage");
            var LatestSearchStore = moduleMocks.require("jira/components/search/latestStorage");

            LatestSearchStore.save(search);

            ok(LocalStorage.setItem.calledWith("jira.issue.navigator.latest.search", "{\"hello\":\"blah\"}"),
                "should delegate to save and convert parameter to json string");
        });

        test("save exceptions are wrapped properly", function() {
            var localStore = {};
            moduleMocks.mock("jira/data/local-storage", localStore);
            localStore.setItem = sinon.stub()["throws"](); //throws is an ES3 keyword and YUI can't compile it

            var LatestSearchStore = moduleMocks.require("jira/components/search/latestStorage");

            LatestSearchStore.save({});

            // The test will fail if the exception isn't caught, but we want to verify it's actually thrown also as a
            // bit of internal error checking.
            ok(localStore.setItem.threw());
        });
    });
});
