/**
 * This file is used to wrap the templates exported in the global namespace
 * by Google Closure Compile with an AMD module. The goal of this AMD module
 * is to hold a reference to the templates, even when they are removed from
 * the global namespace.
 *
 * Please, note that this AMD can be used only in JavaScript land. Soy templates
 * still have to use the global reference. In other words, if someone removes
 * the global reference, it needs to be restored *before* executing a template.
 */
define("jira/components/query/templates/issuenavquery", function() {
    "use strict";

    return JIRA.Templates.IssueNavQuery;
});

define("jira/components/query/templates/issuenavquerybasic", function() {
   "use strict";

    return JIRA.Templates.IssueNavQueryBasic;
});

define("jira/components/query/templates/issuenavqueryjql", function() {
    "use strict";

    return JIRA.Templates.IssueNavQueryJql;
});

define("jira/components/query/templates/issues/componentutil", function() {
   "use strict";

    return JIRA.Templates.Issues.ComponentUtil;
});

/**
 * Force an execution of the module factory, in order to capture a reference to
 * the templates in the AMD module. This will allow other AMD modules access the
 * templates even if the global reference is removed. Later, we can restore the
 * global reference if needed (see ../namespace.js)
 */
AJS.namespace("JIRA.Templates.IssueNavQuery", null, require("jira/components/query/templates/issuenavquery"));
AJS.namespace("JIRA.Templates.IssueNavQueryBasic", null, require("jira/components/query/templates/issuenavquerybasic"));
AJS.namespace("JIRA.Templates.IssueNavQueryJql", null, require("jira/components/query/templates/issuenavqueryjql"));
AJS.namespace("JIRA.Templates.Issues.ComponentUtil", null, require("jira/components/query/templates/issues/componentutil"));
