AJS.test.require("com.atlassian.jira.jira-issue-nav-components:query", function() {
    "use strict";

    require([
        "jira/components/query/basic/textquerybuilder"
    ], function(
        TextQueryBuilder
    ) {
        module("jira/components/query/basic/textquerybuilder");

        test("Empty", function() {
            equal(TextQueryBuilder.buildJql(), "");
        });

        test("Single term", function() {
            equal(TextQueryBuilder.buildJql("hi"), "text ~ \"hi\"");
        });

        test("Multiple terms", function() {
            equal(TextQueryBuilder.buildJql("hi everybody"), "text ~ \"hi everybody\"");
        });

        test("Reserved word", function() {
            equal(TextQueryBuilder.buildJql("and"), "text ~ \"and\"");
        });

        test("Whitespace in query", function() {
            equal(TextQueryBuilder.buildJql(" hi"), "text ~ \"hi\"");
            equal(TextQueryBuilder.buildJql("hi "), "text ~ \"hi\"");
            equal(TextQueryBuilder.buildJql("hi   everybody"), "text ~ \"hi everybody\"");
            equal(TextQueryBuilder.buildJql("  hi   dr   nic  "), "text ~ \"hi dr nic\"");
        });

        test("backslash escaping", function() {
            equal(TextQueryBuilder.buildJql("something with a backslash\\"), "text ~ \"something with a backslash\\\\\"");
        });
    });
});
