AJS.test.require(["com.atlassian.jira.jira-issue-nav-components:testutils", "com.atlassian.jira.jira-issue-nav-components:query"], function() {
    "use strict";

    require([
        "jira/components/query/querystatemodel",
        "jira/util/events/types",
        "jira/util/events",
        "jira/util/events/reasons"
    ], function (
        QueryStateModel,
        Types,
        Events,
        Reasons
    ) {
        var AJSTest = window.AJS.test;

        module("jira/components/query/basic/searchereditdialogview", {
            setup: function() {
                this.moduleMocks = AJSTest.mockableModuleContext();

                sinon.spy(Events, "trigger");

                this.moduleMocks.mock("jira/util/events", Events);

                var SearcherEditDialogView = this.moduleMocks.require("jira/components/query/basic/searchereditdialogview");

                this.searcherEditDialogView = new SearcherEditDialogView({
                    queryStateModel: new QueryStateModel(),
                    model: {
                        id: 'id',
                        setInitParams: function() {
                        }
                    }
                });
            },
            teardown: function() {
                Events.trigger.restore();
            }
        });

        test("render() should trigger a JIRA.Events.NEW_CONTENT_ADDED", function() {
            this.searcherEditDialogView.render();

            ok(Events.trigger.calledOnce, "One event is triggered");
            equal(Events.trigger.firstCall.args[0], Types.NEW_CONTENT_ADDED, "Event is JIRA.Events.NEW_CONTENT_ADDED");
            equal(typeof Events.trigger.firstCall.args[1][1], "string", "Ensure event has a reason argument");
            equal(Events.trigger.firstCall.args[1][1], Reasons.criteriaPanelRefreshed, "Event reason is JIRA.CONTENT_ADDED_REASON.criteriaPanelRefreshed");
        });
    });
});
