AJS.test.require(["com.atlassian.jira.jira-issue-nav-components:testutils", "com.atlassian.jira.jira-issue-nav-components:query"], function() {
    "use strict";

    var TestUtils = require("jira/issues/components/testutils");

    require([
        "jira/components/query/basic/clausebuttonview",
        "jira/components/query/querystatemodel"
    ], function(
        ClauseButtonView,
        QueryStateModel
    ) {
        module("jira/components/query/basic/clausebuttonview", {
            setup: function() {
                this.$el = jQuery("<div></div>").appendTo("#qunit-fixture");
            },
            teardown: function() {
                this.$el.remove();
            }
        });

        test("Add filters button doesn't exist when there aren't any more secondary criteria to add", function() {

            var searcherGroupCollection = TestUtils.createSearcherCollection();

            var view = new ClauseButtonView({
                searcherCollection: searcherGroupCollection,
                queryStateModel: new QueryStateModel(),
                el: this.$el
            });
            view.render();
            equal(this.$el.find(".add-criteria:visible").length, 0, "Add criteria button shouldn't exist.");
        });

        test("Add filters button exists when there are more secondary criteria to add", function() {

            var searcherGroupCollection = TestUtils.createSearcherCollection([
                {
                    id: "selectable",
                    groupId: "groupId",
                    groupName: "groupName",
                    name: "searcherName"
                }
            ]);

            var view = new ClauseButtonView({
                searcherCollection: searcherGroupCollection,
                queryStateModel: new QueryStateModel(),
                el: this.$el
            });
            view.render();
            equal(this.$el.find(".add-criteria:visible").length, 1, "Add criteria button should exist.");

        });

        test("'More Criteria' button is disabled while SearcherCollection is noninteractive", function() {
            var searcherCollection = TestUtils.createSearcherCollection();
            var view = new ClauseButtonView({
                searcherCollection: searcherCollection,
                queryStateModel: new QueryStateModel(),
                el: this.$el
            });
            view.render();
            view.dialog.toggle = sinon.spy();
            searcherCollection.setInteractive(false);
            view.$(".add-criteria").click();
            equal(view.dialog.toggle.callCount, 0, "'More Criteria' dropdown cannot be opened when noninteractive");
            searcherCollection.setInteractive(true);
            view.$(".add-criteria").click();
            equal(view.dialog.toggle.callCount, 1, "'More Criteria' dropdown can be opened when interactive");
        });
    });
});
