define("jira/components/query", ["require"], function(require) {
    "use strict";

    var _ = require("jira/components/libs/underscore");
    var jQuery = require("jquery");
    var QueryModule = require("jira/components/query/querymodule");
    var QueryStateModel = require("jira/components/query/querystatemodel");
    var Events = require('jira/util/events');
    var Types = require('jira/util/events/types');

    /**
     * Adds the class 'checkboxmultiselect-container' to the parent form-body div of a sparker.
     * This removes the implicit padding from the container as all other types of searchers
     * have padding by default.
     */
    Events.bind(Types.CHECKBOXMULITSELECT_READY, function(e, $select) {
        $select.closest(".form-body").addClass("checkboxmultiselect-container");
    });

    return function() {

        var CLAUSES = {
            project: AJS.I18n.getText("issues.components.query.searcher.project"),
            issuetype: AJS.I18n.getText("issues.components.query.searcher.issuetype"),
            status: AJS.I18n.getText("issues.components.query.searcher.status"),
            assignee: AJS.I18n.getText("issues.components.query.searcher.assignee"),
            reporter: AJS.I18n.getText("issues.components.query.searcher.reporter"),
            labels: AJS.I18n.getText("issues.components.query.searcher.labels"),
            resolution: AJS.I18n.getText("issues.components.query.searcher.resolution"),
            created: AJS.I18n.getText("issues.components.query.searcher.created.date"),
            updated: AJS.I18n.getText("issues.components.query.searcher.updated.date"),
            resolutiondate: AJS.I18n.getText("issues.components.query.searcher.resolution.date"),
            description: AJS.I18n.getText("issues.components.query.searcher.description"),
            duedate: AJS.I18n.getText("issues.components.query.searcher.due.date"),
            comment: AJS.I18n.getText("issues.components.query.searcher.comment"),
            fixfor: AJS.I18n.getText("issues.components.query.searcher.fix.version"),
            version: AJS.I18n.getText("issues.components.query.searcher.affects.version"),
            component: AJS.I18n.getText("issues.components.query.searcher.component")
        };

        return {

            DEFAULT_CLAUSES: ["project", "issuetype", "status", "assignee"],

            create: function(options) {

                options = _.defaults(options, {
                    primaryClauses: this.DEFAULT_CLAUSES,
                    without: [],
                    style: "generic",
                    /* This has to be true :( - If issue-nav-components is anything below 6.2, the layoutSwitcher option
                     * didn't exist when it was first consumed in 6.1. */
                    layoutSwitcher: true,
                    autocompleteEnabled: true,
                    advancedAutoUpdate: false,
                    basicOrderBy: false,
                    basicAutoUpdate: true,
                    preferredSearchMode: "basic"
                });

                options.primaryClauses = _.reject(options.primaryClauses, function(clause) {
                    return _.contains(options.without, clause.id);
                });

                _.each(options.primaryClauses, function(clause, idx) {
                    if (typeof clause === "string") {
                        if (CLAUSES[clause]) {
                            options.primaryClauses[idx] = {id: clause, name: CLAUSES[clause]};
                        } else {
                            /*eslint-disable no-console */
                            console.error("jira/components/query: You have specified clause [" + clause + "]. " +
                            "But we do not have the i18n string for it, probably a custom field. Instead use {id:" + clause + ", name: '[NAME_HERE]'}");
                            /*eslint-enable no-console */
                        }
                    }
                });

                var queryModule = new QueryModule({
                    queryStateModel: new QueryStateModel({
                        jql: options.jql,
                        without: options.without,
                        style: options.style,
                        layoutSwitcher: options.layoutSwitcher,
                        autocompleteEnabled: options.autocompleteEnabled,
                        advancedAutoUpdate: options.advancedAutoUpdate,
                        basicAutoUpdate: options.basicAutoUpdate,
                        preferredSearchMode: options.preferredSearchMode,
                        basicOrderBy: options.basicOrderBy
                    }),
                    primaryClauses: options.primaryClauses,
                    searchers: options.searchers,
                    context: options.context
                });

                jQuery(options.el).addClass("query-component " + options.style + "-styled");

                queryModule.createAndRenderView(options.el);

                if (options.jql || options.jql === "") {
                    queryModule.resetToQuery(options.jql).always(function() {
                        jQuery(options.el).addClass("ready");
                        // Consumers of this component want to know when the jql (given at construction) is represented in the ui.
                        queryModule.triggerInitialized(options.jql);
                    });
                }
                return queryModule;
            }
        };
    }();
});
