define("jira/components/query/messages", ['require'], function (require) {
    "use strict";

    var Messages = require("jira/message");
    var SmartAjax = require("jira/ajs/ajax/smart-ajax");

    return {
        /**
         * Determines the appropriate message to show upon search ajax failure
         *
         * @param xhr XHR object from jQuery.ajax
         */
        displayFailSearchMessage: function(xhr) {
            if (xhr && xhr.statusText !== "abort") {
                return Messages.showErrorMsg(SmartAjax.buildSimpleErrorContent(xhr), {
                    closeable: true
                });
            }
        }
    };
});
